/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class RobustScaler
extends Transformer {
    public RobustScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> scale;
        Boolean withCentering = this.getWithCentering();
        Boolean withScaling = this.getWithScaling();
        List<? extends Number> center = withCentering != false ? this.getCenter() : null;
        List<? extends Number> list = scale = withScaling != false ? this.getScale() : null;
        if (center == null && scale == null) {
            return inputFeatures;
        }
        if (ids.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        if (withCentering.booleanValue() && inputFeatures.size() != center.size()) {
            throw new IllegalArgumentException();
        }
        if (withScaling.booleanValue() && inputFeatures.size() != scale.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            Number scaleValue;
            Number centerValue;
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            FieldRef expression = inputFeature.ref();
            if (withCentering.booleanValue() && !ValueUtil.isZero((Number)(centerValue = center.get(i)))) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)centerValue)});
            }
            if (withScaling.booleanValue() && !ValueUtil.isOne((Number)(scaleValue = scale.get(i)))) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)scaleValue)});
            }
            if (expression instanceof FieldRef) {
                features.add(inputFeature);
                continue;
            }
            DerivedField derivedField = featureMapper.createDerivedField(this.createName(id), (Expression)expression);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public Boolean getWithCentering() {
        return (Boolean)this.get("with_centering");
    }

    public Boolean getWithScaling() {
        return (Boolean)this.get("with_scaling");
    }

    public List<? extends Number> getCenter() {
        return ClassDictUtil.getArray(this, "center_");
    }

    public List<? extends Number> getScale() {
        return ClassDictUtil.getArray(this, "scale_");
    }
}

