/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class StandardScaler
extends Transformer {
    public StandardScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> std;
        Boolean withMean = this.getWithMean();
        Boolean withStd = this.getWithStd();
        List<? extends Number> mean = withMean != false ? this.getMean() : null;
        List<? extends Number> list = std = withStd != false ? this.getStd() : null;
        if (mean == null && std == null) {
            return inputFeatures;
        }
        if (ids.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        if (withMean.booleanValue() && inputFeatures.size() != mean.size()) {
            throw new IllegalArgumentException();
        }
        if (withStd.booleanValue() && inputFeatures.size() != std.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            Number stdValue;
            Number meanValue;
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            FieldRef expression = inputFeature.ref();
            if (withMean.booleanValue() && !ValueUtil.isZero((Number)(meanValue = mean.get(i)))) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)meanValue)});
            }
            if (withStd.booleanValue() && !ValueUtil.isOne((Number)(stdValue = std.get(i)))) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)stdValue)});
            }
            if (expression instanceof FieldRef) {
                features.add(inputFeature);
                continue;
            }
            DerivedField derivedField = featureMapper.createDerivedField(this.createName(id), (Expression)expression);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public Boolean getWithMean() {
        return (Boolean)this.get("with_mean");
    }

    public Boolean getWithStd() {
        return (Boolean)this.get("with_std");
    }

    public List<? extends Number> getMean() {
        return ClassDictUtil.getArray(this, "mean_");
    }

    public List<? extends Number> getStd() {
        try {
            return ClassDictUtil.getArray(this, "std_");
        }
        catch (IllegalArgumentException iae) {
            return ClassDictUtil.getArray(this, "scale_");
        }
    }
}

