/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.converter.PMMLMapper;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.WildcardFeature;

public class FeatureMapper
extends PMMLMapper {
    private List<List<Feature>> rows = new ArrayList<List<Feature>>();

    public Schema createSupervisedSchema() {
        WildcardFeature feature = this.getTargetFeature();
        DataField dataField = this.getDataField(feature.getName());
        if (dataField == null) {
            throw new IllegalArgumentException();
        }
        FieldName targetField = dataField.getName();
        List targetCategories = null;
        if (dataField.hasValues()) {
            targetCategories = PMMLUtil.getValues((DataField)dataField);
        }
        ArrayList activeFields = new ArrayList(this.getDataFields().keySet());
        activeFields.remove(targetField);
        List<Feature> features = this.getActiveFeatures(true);
        Schema schema = new Schema(targetField, targetCategories, activeFields, features);
        return schema;
    }

    public Schema createUnsupervisedSchema() {
        ArrayList activeFields = new ArrayList(this.getDataFields().keySet());
        List<Feature> features = this.getActiveFeatures(false);
        Schema schema = new Schema(null, null, activeFields, features);
        return schema;
    }

    public Schema cast(OpType opType, DataType dataType, Schema schema) {
        if (opType != null && !OpType.CONTINUOUS.equals((Object)opType)) {
            throw new IllegalArgumentException();
        }
        String function = dataType.name().toLowerCase();
        ArrayList<Feature> castFeatures = new ArrayList<Feature>();
        List features = schema.getFeatures();
        for (Feature feature : features) {
            ContinuousFeature continuousFeature;
            DerivedField derivedField;
            FieldName name;
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                if (opType != null) {
                    name = FieldName.create((String)(function + "(" + binaryFeature.getName().getValue() + "=" + binaryFeature.getValue() + ")"));
                    derivedField = this.getDerivedField(name);
                    if (derivedField == null) {
                        NormDiscrete normDiscrete = new NormDiscrete(binaryFeature.getName(), binaryFeature.getValue());
                        derivedField = this.createDerivedField(name, OpType.CONTINUOUS, dataType, (Expression)normDiscrete);
                    }
                    feature = new ContinuousFeature((TypeDefinitionField)derivedField);
                }
            } else if (feature instanceof ContinuousFeature && !((continuousFeature = (ContinuousFeature)feature) instanceof ListFeature) && !continuousFeature.getDataType().equals((Object)dataType)) {
                name = FieldName.create((String)(function + "(" + continuousFeature.getName().getValue() + ")"));
                derivedField = this.getDerivedField(name);
                if (derivedField == null) {
                    derivedField = this.createDerivedField(name, OpType.CONTINUOUS, dataType, (Expression)continuousFeature.ref());
                }
                feature = new ContinuousFeature((TypeDefinitionField)derivedField);
            }
            castFeatures.add(feature);
        }
        Schema castSchema = new Schema(schema.getTargetField(), schema.getTargetCategories(), schema.getActiveFields(), castFeatures);
        return castSchema;
    }

    public void updateType(FieldName name, OpType opType, DataType dataType) {
        TypeDefinitionField field = this.getField(name);
        field.setOpType(opType).setDataType(dataType);
    }

    public void updateValueSpace(FieldName name, List<String> categories) {
        TypeDefinitionField field = this.getField(name);
        List values = field.getValues();
        if (values.size() > 0) {
            throw new IllegalArgumentException();
        }
        if (categories != null && categories.size() > 0) {
            values.addAll(PMMLUtil.createValues(categories));
        }
    }

    public void initTargetField(FieldName name, OpType opType, DataType dataType, List<String> targetCategories) {
        DataField dataField = this.createDataField(name, opType, dataType);
        this.updateValueSpace(dataField.getName(), targetCategories);
        WildcardFeature feature = new WildcardFeature((TypeDefinitionField)dataField);
        this.addRow(Collections.singletonList(feature));
    }

    public void updateTargetField(OpType opType, DataType dataType, List<String> targetCategories) {
        WildcardFeature feature = this.getTargetFeature();
        DataField dataField = this.getDataField(feature.getName());
        if (dataField == null) {
            throw new IllegalArgumentException();
        }
        this.updateType(dataField.getName(), opType, dataType);
        this.updateValueSpace(dataField.getName(), targetCategories);
    }

    public void initActiveFields(List<FieldName> names, OpType opType, DataType dataType) {
        if (!OpType.CONTINUOUS.equals((Object)opType)) {
            throw new IllegalArgumentException();
        }
        for (FieldName name : names) {
            DataField dataField = this.createDataField(name, opType, dataType);
            ContinuousFeature feature = new ContinuousFeature((TypeDefinitionField)dataField);
            this.addRow(Collections.singletonList(feature));
        }
    }

    public void updateActiveFields(int numberOfFeatures, boolean supervised, OpType opType, DataType dataType) {
        if (!OpType.CONTINUOUS.equals((Object)opType)) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        List<List<Feature>> activeRows = this.getActiveRows(supervised);
        for (List<Feature> activeRow : activeRows) {
            ListIterator<Feature> featureIt = activeRow.listIterator();
            while (featureIt.hasNext()) {
                Feature feature = featureIt.next();
                ++count;
                if (feature instanceof BinaryFeature) continue;
                this.updateType(feature.getName(), opType, dataType);
                if (!(feature instanceof WildcardFeature)) continue;
                DataField dataField = (DataField)this.getField(feature.getName());
                feature = new ContinuousFeature((TypeDefinitionField)dataField);
                featureIt.set(feature);
            }
        }
        if (count != numberOfFeatures) {
            throw new IllegalArgumentException();
        }
    }

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public WildcardFeature getTargetFeature() {
        List<Feature> targetRow = this.getTargetRow();
        if (targetRow.size() != 1) {
            throw new IllegalArgumentException();
        }
        WildcardFeature feature = (WildcardFeature)targetRow.get(0);
        return feature;
    }

    public List<Feature> getActiveFeatures(boolean supervised) {
        List<List<Feature>> activeRows = this.getActiveRows(supervised);
        ArrayList features = Lists.newArrayList((Iterable)Iterables.concat(activeRows));
        return features;
    }

    public void addRow(List<Feature> row) {
        this.rows.add(row);
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public List<List<Feature>> getRows() {
        return this.rows;
    }

    public List<Feature> getTargetRow() {
        return this.rows.get(this.rows.size() - 1);
    }

    public List<List<Feature>> getActiveRows(boolean supervised) {
        if (supervised) {
            return this.rows.subList(0, this.rows.size() - 1);
        }
        return this.rows;
    }
}

