/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Extension;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import org.jpmml.sklearn.PickleUtil;
import org.jpmml.sklearn.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn_pandas.DataFrameMapper;

public class Main {
    @Parameter(names={"--pkl-input", "--pkl-estimator-input"}, description="Estimator pickle input file", required=true)
    private File estimatorInput = null;
    @Parameter(names={"--repr-estimator"}, description="Estimator string representation", hidden=true)
    private String estimatorRepr = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--pkl-mapper-input"}, description="DataFrameMapper pickle input file", required=false)
    private File mapperInput = null;
    @Parameter(names={"--repr-mapper"}, description="DataFrameMapper string representation", hidden=true)
    private String mapperRepr = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            commander.usage();
            System.exit(-1);
        }
        if (main.help) {
            commander.usage();
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        PMML pmml;
        long end;
        long end2;
        long start;
        Throwable throwable;
        Storage storage;
        FeatureMapper featureMapper = new FeatureMapper();
        LinkedHashMap<String, String> reprs = new LinkedHashMap<String, String>();
        if (this.mapperInput != null) {
            storage = PickleUtil.createStorage(this.mapperInput);
            throwable = null;
            try {
                Object object;
                try {
                    logger.info("Parsing DataFrameMapper PKL..");
                    long start2 = System.currentTimeMillis();
                    object = PickleUtil.unpickle(storage);
                    long end22 = System.currentTimeMillis();
                    logger.info("Parsed DataFrameMapper PKL in {} ms.", (Object)(end22 - start2));
                }
                catch (Exception e) {
                    logger.error("Failed to parse DataFrameMapper PKL", (Throwable)e);
                    throw e;
                }
                if (!(object instanceof DataFrameMapper)) {
                    throw new IllegalArgumentException("The mapper object (" + ClassDictUtil.formatClass(object) + ") is not a DataFrameMapper");
                }
                DataFrameMapper mapper = (DataFrameMapper)((Object)object);
                try {
                    logger.info("Converting DataFrameMapper..");
                    start = System.currentTimeMillis();
                    mapper.encodeFeatures(featureMapper);
                    end2 = System.currentTimeMillis();
                    logger.info("Converted DataFrameMapper in {} ms.", (Object)(end2 - start));
                }
                catch (Exception e) {
                    logger.error("Failed to convert DataFrameMapper", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (storage != null) {
                    if (throwable != null) {
                        try {
                            storage.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        storage.close();
                    }
                }
            }
            if (this.mapperRepr != null) {
                reprs.put("mapper", this.mapperRepr);
            }
        }
        storage = PickleUtil.createStorage(this.estimatorInput);
        throwable = null;
        try {
            Object object;
            try {
                logger.info("Parsing Estimator PKL..");
                long start3 = System.currentTimeMillis();
                object = PickleUtil.unpickle(storage);
                end = System.currentTimeMillis();
                logger.info("Parsed Estimator PKL in {} ms.", (Object)(end - start3));
            }
            catch (Exception e) {
                logger.error("Failed to parse Estimator PKL", (Throwable)e);
                throw e;
            }
            if (!(object instanceof Estimator)) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not an Estimator or is not a supported Estimator subclass");
            }
            Estimator estimator = (Estimator)((Object)object);
            try {
                logger.info("Converting Estimator..");
                start = System.currentTimeMillis();
                pmml = EstimatorUtil.encodePMML(estimator, featureMapper);
                end2 = System.currentTimeMillis();
                logger.info("Converted Estimator in {} ms.", (Object)(end2 - start));
            }
            catch (Exception e) {
                logger.error("Failed to convert Estimator", (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (storage != null) {
                if (throwable != null) {
                    try {
                        storage.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    storage.close();
                }
            }
        }
        if (this.estimatorRepr != null) {
            reprs.put("estimator", this.estimatorRepr);
        }
        Set entries = reprs.entrySet();
        for (Map.Entry entry : entries) {
            Main.addObjectRepr(pmml, (String)entry.getKey(), (String)entry.getValue());
        }
        try {
            Throwable throwable6 = null;
            try (FileOutputStream os = new FileOutputStream(this.output);){
                logger.info("Marshalling PMML..");
                long start4 = System.currentTimeMillis();
                MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
                end = System.currentTimeMillis();
                logger.info("Marshalled PMML in {} ms.", (Object)(end - start4));
            }
            catch (Throwable throwable7) {
                Throwable throwable8 = throwable7;
                throw throwable7;
            }
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public File getEstimatorInput() {
        return this.estimatorInput;
    }

    public void setEstimatorInput(File estimatorInput) {
        this.estimatorInput = estimatorInput;
    }

    public File getMapperInput() {
        return this.mapperInput;
    }

    public void setMapperInput(File mapperInput) {
        this.mapperInput = mapperInput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    private static void addObjectRepr(PMML pmml, String name, String content) {
        MiningBuildTask miningBuildTask = pmml.getMiningBuildTask();
        if (miningBuildTask == null) {
            miningBuildTask = new MiningBuildTask();
            pmml.setMiningBuildTask(miningBuildTask);
        }
        Extension extension = new Extension().setName(name).setValue("repr(" + name + ")").addContent(new Object[]{content});
        miningBuildTask.addExtensions(new Extension[]{extension});
    }
}

