/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Estimator;
import sklearn.TypeUtil;

public abstract class Classifier
extends Estimator {
    public Classifier(String module, String name) {
        super(module, name);
    }

    @Override
    public Schema createSchema(FeatureMapper featureMapper) {
        List<?> classes = this.getClasses();
        if (classes == null || classes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        DataType dataType = TypeUtil.getDataType(classes, DataType.STRING);
        List<String> targetCategories = Classifier.formatTargetCategories(classes);
        if (featureMapper.isEmpty()) {
            featureMapper.initActiveFields(this.createActiveFields(this.getNumberOfFeatures()), this.getOpType(), this.getDataType());
            featureMapper.initTargetField(this.createTargetField(), OpType.CATEGORICAL, dataType, targetCategories);
        } else {
            featureMapper.updateActiveFields(this.getNumberOfFeatures(), true, this.getOpType(), this.getDataType());
            featureMapper.updateTargetField(OpType.CATEGORICAL, dataType, targetCategories);
        }
        Schema schema = featureMapper.createSupervisedSchema();
        if (this.requiresContinuousInput()) {
            schema = featureMapper.cast(OpType.CONTINUOUS, this.getDataType(), schema);
        }
        return schema;
    }

    public boolean hasProbabilityDistribution() {
        return true;
    }

    public List<?> getClasses() {
        return ClassDictUtil.getArray(this, "classes_");
    }

    private static List<String> formatTargetCategories(List<?> objects) {
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                String targetCategory = ValueUtil.formatValue((Object)object);
                if (targetCategory == null || CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)targetCategory)) {
                    throw new IllegalArgumentException(targetCategory);
                }
                return targetCategory;
            }
        };
        return new ArrayList<String>(Lists.transform(objects, (Function)function));
    }
}

