/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LabelBinarizer
extends Transformer {
    public LabelBinarizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<?> classes = this.getClasses();
        Number posLabel = this.getPosLabel();
        Number negLabel = this.getNegLabel();
        if (ids.size() != 1 || inputFeatures.size() != 1) {
            throw new IllegalArgumentException();
        }
        String id = ids.get(0);
        Feature inputFeature = inputFeatures.get(0);
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < classes.size(); ++i) {
            BinaryFeature feature;
            Object value = classes.get(i);
            if (ValueUtil.isOne((Number)posLabel) && ValueUtil.isZero((Number)negLabel)) {
                String category = ValueUtil.formatValue(value);
                categories.add(category);
                feature = new BinaryFeature(inputFeature.getName(), DataType.STRING, category);
            } else {
                Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{inputFeature.ref(), PMMLUtil.createConstant(value)}), PMMLUtil.createConstant((Object)posLabel), PMMLUtil.createConstant((Object)negLabel)});
                DerivedField derivedField = featureMapper.createDerivedField(this.createName(id, i), (Expression)apply);
                feature = new ContinuousFeature((TypeDefinitionField)derivedField);
            }
            features.add((Feature)feature);
        }
        featureMapper.updateValueSpace(inputFeature.getName(), categories);
        return features;
    }

    public List<?> getClasses() {
        return ClassDictUtil.getArray(this, "classes_");
    }

    public Number getPosLabel() {
        return (Number)this.get("pos_label");
    }

    public Number getNegLabel() {
        return (Number)this.get("neg_label");
    }
}

