/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;

public class MaxAbsScaler
extends Transformer {
    public MaxAbsScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> scale = this.getScale();
        if (ids.size() != inputFeatures.size() || scale.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            String id = ids.get(i);
            Feature inputFeature = inputFeatures.get(i);
            Number value = scale.get(i);
            if (ValueUtil.isOne((Number)value)) {
                features.add(inputFeature);
                continue;
            }
            Apply apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{inputFeature.ref(), PMMLUtil.createConstant((Object)value)});
            DerivedField derivedField = featureMapper.createDerivedField(this.createName(id), (Expression)apply);
            features.add((Feature)new ContinuousFeature((TypeDefinitionField)derivedField));
        }
        return features;
    }

    public List<? extends Number> getScale() {
        return ClassDictUtil.getArray(this, "scale_");
    }
}

