/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.bagging;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.HasArray;
import sklearn.Estimator;

public class BaggingUtil {
    private BaggingUtil() {
    }

    public static <E extends Estimator> MiningModel encodeBagging(List<E> estimators, List<List<Integer>> estimatorsFeatures, Segmentation.MultipleModelMethod multipleModelMethod, MiningFunction miningFunction, Schema schema) {
        ArrayList<Model> models = new ArrayList<Model>();
        for (int i = 0; i < estimators.size(); ++i) {
            Estimator estimator = (Estimator)((Object)estimators.get(i));
            List<Integer> estimatorFeatures = estimatorsFeatures.get(i);
            Schema estimatorSchema = schema.toSubSchema(Ints.toArray(estimatorFeatures));
            Model model = estimator.encodeModel(estimatorSchema);
            models.add(model);
        }
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Schema)schema)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, models));
        return miningModel;
    }

    public static <E extends Estimator> Set<DefineFunction> encodeDefineFunctions(List<E> estimators) {
        LinkedHashMap<String, DefineFunction> result = new LinkedHashMap<String, DefineFunction>();
        for (Estimator estimator : estimators) {
            Set<DefineFunction> defineFunctions = estimator.encodeDefineFunctions();
            for (DefineFunction defineFunction : defineFunctions) {
                result.put(defineFunction.getName(), defineFunction);
            }
        }
        return new LinkedHashSet<DefineFunction>(result.values());
    }

    public static List<List<Integer>> transformEstimatorsFeatures(List<?> estimatorsFeatures) {
        Function<Object, List<Integer>> function = new Function<Object, List<Integer>>(){

            public List<Integer> apply(Object object) {
                if (object instanceof HasArray) {
                    HasArray hasArray = (HasArray)object;
                    return ValueUtil.asIntegers(hasArray.getArrayContent());
                }
                throw new IllegalArgumentException("The estimator features object (" + ClassDictUtil.formatClass(object) + ") is not an array");
            }
        };
        return Lists.transform(estimatorsFeatures, (Function)function);
    }
}

