/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Selector;

public class SelectKBest
extends Selector {
    public SelectKBest(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<? extends Number> scores = this.getScores();
        return scores.size();
    }

    @Override
    public List<Feature> selectFeatures(List<Feature> inputFeatures) {
        FeatureScore featureScore;
        Object k = this.getK();
        List<? extends Number> scores = this.getScores();
        if (inputFeatures.size() != scores.size()) {
            throw new IllegalArgumentException();
        }
        if ("all".equals(k)) {
            return inputFeatures;
        }
        ArrayList<FeatureScore> featureScores = new ArrayList<FeatureScore>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            Feature inputFeature = inputFeatures.get(i);
            Number score = scores.get(i);
            featureScore = new FeatureScore(inputFeature, score.doubleValue());
            featureScores.add(featureScore);
        }
        Collections.sort(featureScores, Collections.reverseOrder());
        ArrayList<Feature> features = new ArrayList<Feature>();
        int max = ValueUtil.asInt((Number)((Number)k));
        for (int i = 0; i < max; ++i) {
            featureScore = (FeatureScore)featureScores.get(i);
            Feature feature = featureScore.getFeature();
            features.add(feature);
        }
        return features;
    }

    public Object getK() {
        return this.get("k");
    }

    public List<? extends Number> getScores() {
        return ClassDictUtil.getArray(this, "scores_");
    }

    private static class FeatureScore
    implements Comparable<FeatureScore> {
        private Feature feature;
        private double score;

        public FeatureScore(Feature feature, double score) {
            this.setFeature(feature);
            this.setScore(score);
        }

        @Override
        public int compareTo(FeatureScore that) {
            return Double.compare(this.getScore(), that.getScore());
        }

        public Feature getFeature() {
            return this.feature;
        }

        private void setFeature(Feature feature) {
            this.feature = feature;
        }

        public double getScore() {
            return this.score;
        }

        private void setScore(double score) {
            this.score = score;
        }
    }
}

