/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;
import sklearn.linear_model.BaseLinearUtil;

public abstract class BaseLinearRegressor
extends Regressor {
    public BaseLinearRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[0];
    }

    @Override
    public boolean requiresContinuousInput() {
        return false;
    }

    public RegressionModel encodeModel(Schema schema) {
        return BaseLinearUtil.encodeRegressionModel((Number)Iterables.getOnlyElement(this.getIntercept()), this.getCoef(), schema);
    }

    public List<? extends Number> getCoef() {
        return ClassDictUtil.getArray(this, "coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "intercept_");
    }

    private int[] getCoefShape() {
        return ClassDictUtil.getShape(this, "coef_", 1);
    }
}

