/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Model;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.FeatureMapper;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.Selector;
import sklearn.TransformerUtil;

public class Pipeline
extends Estimator {
    public Pipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        Iterator<Selector> i$;
        List<Selector> selectors = this.getSelectors();
        Estimator estimator = this.getEstimator();
        if (selectors.size() > 0 && (i$ = selectors.iterator()).hasNext()) {
            Selector selector = i$.next();
            return selector.getNumberOfFeatures();
        }
        return estimator.getNumberOfFeatures();
    }

    @Override
    public Schema createSchema(FeatureMapper featureMapper) {
        List<Selector> selectors = this.getSelectors();
        Estimator estimator = this.getEstimator();
        if (selectors.size() > 0 && featureMapper.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return estimator.createSchema(featureMapper);
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<Selector> selectors = this.getSelectors();
        Estimator estimator = this.getEstimator();
        if (selectors.size() > 0) {
            List<Feature> features = schema.getFeatures();
            for (Selector selector : selectors) {
                int numberOfFeatures = selector.getNumberOfFeatures();
                if (features.size() != numberOfFeatures) {
                    throw new IllegalArgumentException();
                }
                features = selector.selectFeatures(features);
            }
            schema = new Schema(schema.getTargetField(), schema.getTargetCategories(), schema.getActiveFields(), (List)features);
        }
        return estimator.encodeModel(schema);
    }

    public List<Selector> getSelectors() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException();
        }
        List<Object[]> selectorSteps = steps.subList(0, steps.size() - 1);
        return TransformerUtil.asSelectorList(TupleUtil.extractElement(selectorSteps, 1));
    }

    public Estimator getEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException();
        }
        Object[] estimatorStep = steps.get(steps.size() - 1);
        String name = (String)estimatorStep[0];
        Estimator estimator = EstimatorUtil.asEstimator(estimatorStep[1]);
        return estimator;
    }

    public List<Object[]> getSteps() {
        return (List)this.get("steps");
    }
}

