/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.FeatureMapper;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class OneHotEncoder
extends Transformer {
    public OneHotEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<? extends Number> values = this.getValues();
        return TypeUtil.getDataType(values, DataType.INTEGER);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> inputFeatures, FeatureMapper featureMapper) {
        List<? extends Number> values = this.getValues();
        if (ids.size() != 1 || inputFeatures.size() != 1) {
            throw new IllegalArgumentException();
        }
        Feature inputFeature = inputFeatures.get(0);
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < values.size(); ++i) {
            String category;
            int value = ValueUtil.asInt((Number)values.get(i));
            if (inputFeature instanceof ListFeature) {
                ListFeature listFeature = (ListFeature)inputFeature;
                category = listFeature.getValue(value);
            } else if (inputFeature instanceof WildcardFeature) {
                category = ValueUtil.formatValue((Number)value);
            } else {
                throw new IllegalArgumentException();
            }
            categories.add(category);
            features.add((Feature)new BinaryFeature(inputFeature.getName(), DataType.STRING, category));
        }
        featureMapper.updateValueSpace(inputFeature.getName(), categories);
        return features;
    }

    public List<? extends Number> getValues() {
        List<Integer> featureSizes = this.getFeatureSizes();
        if (featureSizes.size() != 1) {
            throw new IllegalArgumentException();
        }
        Object numberOfValues = this.get("n_values");
        if ("auto".equals(numberOfValues)) {
            return this.getActiveFeatures();
        }
        Integer featureSize = featureSizes.get(0);
        ArrayList result = new ArrayList();
        result.addAll(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)featureSize), (DiscreteDomain)DiscreteDomain.integers()));
        return result;
    }

    public List<? extends Number> getActiveFeatures() {
        return ClassDictUtil.getArray(this, "active_features_");
    }

    public List<Integer> getFeatureSizes() {
        return ValueUtil.asIntegers(ClassDictUtil.getArray(this, "n_values_"));
    }
}

