/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.EstimatorUtil;
import sklearn.linear_model.BaseLinearUtil;

public abstract class BaseLinearClassifier
extends Classifier {
    public BaseLinearClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[1];
    }

    public RegressionModel encodeModel(Schema schema) {
        int[] shape = this.getCoefShape();
        int numberOfClasses = shape[0];
        int numberOfFeatures = shape[1];
        boolean hasProbabilityDistribution = this.hasProbabilityDistribution();
        List<? extends Number> coefficients = this.getCoef();
        List<? extends Number> intercepts = this.getIntercept();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        if (numberOfClasses == 1) {
            EstimatorUtil.checkSize(2, categoricalLabel);
            RegressionTable activeRegressionTable = BaseLinearUtil.encodeRegressionTable(features, intercepts.get(0), CMatrixUtil.getRow(coefficients, (int)numberOfClasses, (int)numberOfFeatures, (int)0)).setTargetCategory(categoricalLabel.getValue(1));
            RegressionTable passiveRegressionTable = RegressionModelUtil.createRegressionTable(Collections.emptyList(), null, Collections.emptyList()).setTargetCategory(categoricalLabel.getValue(0));
            RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Schema)schema), null).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).addRegressionTables(new RegressionTable[]{activeRegressionTable, passiveRegressionTable}).setOutput(hasProbabilityDistribution ? ModelUtil.createProbabilityOutput((CategoricalLabel)categoricalLabel) : null);
            return regressionModel;
        }
        if (numberOfClasses >= 3) {
            EstimatorUtil.checkSize(numberOfClasses, categoricalLabel);
            ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
            int rows = categoricalLabel.size();
            for (int i = 0; i < rows; ++i) {
                RegressionTable regressionTable = BaseLinearUtil.encodeRegressionTable(features, intercepts.get(i), CMatrixUtil.getRow(coefficients, (int)numberOfClasses, (int)numberOfFeatures, (int)i)).setTargetCategory(categoricalLabel.getValue(i));
                regressionTables.add(regressionTable);
            }
            RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Schema)schema), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.LOGIT).setOutput(hasProbabilityDistribution ? ModelUtil.createProbabilityOutput((CategoricalLabel)categoricalLabel) : null);
            return regressionModel;
        }
        throw new IllegalArgumentException();
    }

    public List<? extends Number> getCoef() {
        return ClassDictUtil.getArray(this, "coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "intercept_");
    }

    private int[] getCoefShape() {
        return ClassDictUtil.getShape(this, "coef_", 2);
    }
}

