/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;
import sklearn.svm.SupportVectorMachineUtil;

public abstract class BaseLibSVMRegressor
extends Regressor {
    public BaseLibSVMRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<? extends Number> supportVectors = this.getSupportVectors();
        List<? extends Number> dualCoef = this.getDualCoef();
        List<? extends Number> intercept = this.getIntercept();
        VectorDictionary vectorDictionary = SupportVectorMachineUtil.encodeVectorDictionary(support, supportVectors, numberOfVectors, numberOfFeatures, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        Kernel kernel = SupportVectorMachineUtil.encodeKernel(this.getKernel(), this.getDegree(), this.getGamma(), this.getCoef0());
        SupportVectorMachine supportVectorMachine = SupportVectorMachineUtil.encodeSupportVectorMachine(vectorInstances, dualCoef, (Number)Iterables.getOnlyElement(intercept));
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema), vectorDictionary, null).setKernel(kernel).addSupportVectorMachines(new SupportVectorMachine[]{supportVectorMachine});
        return supportVectorMachineModel;
    }

    public String getKernel() {
        return (String)this.get("kernel");
    }

    public Integer getDegree() {
        return ValueUtil.asInteger((Number)((Number)this.get("degree")));
    }

    public Double getGamma() {
        return ValueUtil.asDouble((Number)((Number)this.get("_gamma")));
    }

    public Double getCoef0() {
        return ValueUtil.asDouble((Number)((Number)this.get("coef0")));
    }

    public List<Integer> getSupport() {
        return ValueUtil.asIntegers(ClassDictUtil.getArray(this, "support_"));
    }

    public List<? extends Number> getSupportVectors() {
        return ClassDictUtil.getArray(this, "support_vectors_");
    }

    public List<? extends Number> getDualCoef() {
        return ClassDictUtil.getArray(this, "_dual_coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "_intercept_");
    }

    private int[] getSupportVectorsShape() {
        return ClassDictUtil.getShape(this, "support_vectors_", 2);
    }
}

