/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.preprocessing.LabelEncoder;
import xgboost.sklearn.Booster;
import xgboost.sklearn.BoosterUtil;
import xgboost.sklearn.HasBooster;

public class XGBClassifier
extends Classifier
implements HasBooster {
    public XGBClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return BoosterUtil.getNumberOfFeatures(this);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public List<?> getClasses() {
        LabelEncoder labelEncoder = this.getLabelEncoder();
        return labelEncoder.getClasses();
    }

    public MiningModel encodeModel(Schema schema) {
        return BoosterUtil.encodeBooster(this, schema);
    }

    @Override
    public Booster getBooster() {
        return (Booster)((Object)this.get("_Booster"));
    }

    public LabelEncoder getLabelEncoder() {
        Object object = this.get("_le");
        try {
            if (object == null) {
                throw new NullPointerException();
            }
            return (LabelEncoder)((Object)object);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("The label encoder object (" + ClassDictUtil.formatClass(object) + ") is not a LabelEncoder", re);
        }
    }
}

