/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.iforest;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import numpy.core.Scalar;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.model.visitors.AbstractVisitor;
import sklearn.Regressor;
import sklearn.ensemble.EnsembleRegressor;
import sklearn.tree.ExtraTreeRegressor;
import sklearn.tree.Tree;
import sklearn.tree.TreeModelUtil;

public class IsolationForest
extends EnsembleRegressor {
    public IsolationForest(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    public MiningModel encodeModel(Schema schema) {
        List<? extends Regressor> estimators = this.getEstimators();
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (Regressor regressor : estimators) {
            ExtraTreeRegressor treeRegressor = (ExtraTreeRegressor)regressor;
            final Tree tree = treeRegressor.getTree();
            TreeModel treeModel = TreeModelUtil.encodeTreeModel(treeRegressor, MiningFunction.REGRESSION, segmentSchema);
            AbstractVisitor visitor = new AbstractVisitor(){
                private int[] nodeSamples;
                {
                    this.nodeSamples = tree.getNodeSamples();
                }

                public VisitorAction visit(Node node) {
                    if (node.getScore() != null) {
                        PMMLObject parent;
                        double nodeDepth = 0.0;
                        Deque parents = this.getParents();
                        Iterator i$ = parents.iterator();
                        while (i$.hasNext() && (parent = (PMMLObject)i$.next()) instanceof Node) {
                            nodeDepth += 1.0;
                        }
                        double nodeSample = this.nodeSamples[Integer.parseInt(node.getId()) - 1];
                        node.setScore(ValueUtil.formatValue((Number)(nodeDepth + IsolationForest.averagePathLength(nodeSample))));
                    }
                    return super.visit(node);
                }
            };
            visitor.applyTo((Visitable)treeModel);
            treeModels.add(treeModel);
        }
        OutputField rawAnomalyScore = new OutputField(FieldName.create((String)"rawAnomalyScore"), DataType.DOUBLE).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.PREDICTED_VALUE).setFinalResult(Boolean.valueOf(false));
        OutputField outputField = new OutputField(FieldName.create((String)"normalizedAnomalyScore"), DataType.DOUBLE).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(false)).setExpression((Expression)PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{new FieldRef(rawAnomalyScore.getName()), PMMLUtil.createConstant((Object)IsolationForest.averagePathLength(this.getMaxSamples()))}));
        OutputField decisionFunction = new OutputField(FieldName.create((String)"decisionFunction"), DataType.DOUBLE).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(false)).setExpression((Expression)PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)0.5), PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)2.0), PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)-1.0), new FieldRef(outputField.getName())})})}));
        OutputField outlier = new OutputField(FieldName.create((String)"outlier"), DataType.BOOLEAN).setOpType(OpType.CATEGORICAL).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression((Expression)PMMLUtil.createApply((String)"lessOrEqual", (Expression[])new Expression[]{new FieldRef(decisionFunction.getName()), PMMLUtil.createConstant((Object)this.getThreshold())}));
        Output output = new Output().addOutputFields(new OutputField[]{rawAnomalyScore, outputField, decisionFunction, outlier});
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.AVERAGE, treeModels)).setOutput(output);
        return miningModel;
    }

    public int getMaxSamples() {
        return ValueUtil.asInt((Number)((Number)this.get("max_samples_")));
    }

    public double getThreshold() {
        Scalar threshold = (Scalar)this.get("threshold_");
        List<?> content = threshold.getContent();
        return ValueUtil.asDouble((Number)((Number)content.get(0)));
    }

    private static double averagePathLength(double n) {
        if (n <= 1.0) {
            return 1.0;
        }
        return 2.0 * (Math.log(n) + 0.5772156649) - 2.0 * ((n - 1.0) / n);
    }
}

