/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.neighbors.HasNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsClassifier
extends Classifier
implements HasNeighbors,
HasTrainingData {
    public KNeighborsClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLASSIFICATION, numberOfInstances, numberOfFeatures, schema).setCategoricalScoringMethod(NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE);
        return nearestNeighborModel;
    }

    @Override
    public int getNumberOfNeighbors() {
        return ValueUtil.asInt((Number)((Number)this.get("n_neighbors")));
    }

    @Override
    public String getWeights() {
        return (String)this.get("weights");
    }

    @Override
    public String getMetric() {
        return (String)this.get("metric");
    }

    @Override
    public int getP() {
        return ValueUtil.asInt((Number)((Number)this.get("p")));
    }

    @Override
    public List<?> getY() {
        List<?> y = ClassDictUtil.getArray(this, "_y");
        final List<?> classes = this.getClasses();
        Function<Number, Object> function = new Function<Number, Object>(){

            public Object apply(Number number) {
                int index = ValueUtil.asInt((Number)number);
                return classes.get(index);
            }
        };
        return Lists.transform(y, (Function)function);
    }

    @Override
    public List<? extends Number> getFitX() {
        return ClassDictUtil.getArray(this, "_fit_X");
    }

    private int[] getFitXShape() {
        return ClassDictUtil.getShape(this, "_fit_X", 2);
    }
}

