/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;

public class Booster
extends ClassDict {
    private GBDT gbdt = null;

    public Booster(String module, String name) {
        super(module, name);
    }

    public GBDT getGBDT() {
        if (this.gbdt == null) {
            this.gbdt = this.loadGBDT();
        }
        return this.gbdt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GBDT loadGBDT() {
        List<String> handle = this.getHandle();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            List<String> lines = handle;
            for (String line : lines) {
                os.write(line.getBytes("US-ASCII"));
            }
            byte[] buffer = os.toByteArray();
            try (ByteArrayInputStream is = new ByteArrayInputStream(buffer);){
                GBDT gBDT = LightGBMUtil.loadGBDT((InputStream)is);
                return gBDT;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public List<String> getHandle() {
        return (List)this.get("handle");
    }
}

