/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lightgbm.sklearn.Booster;
import lightgbm.sklearn.HasBooster;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.sklearn.SkLearnEncoder;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static int getNumberOfFeatures(HasBooster hasBooster) {
        String[] featureNames;
        Booster booster = hasBooster.getBooster();
        GBDT gbdt = booster.getGBDT();
        try {
            Field field = GBDT.class.getDeclaredField("feature_names_");
            field.setAccessible(true);
            featureNames = (String[])field.get(gbdt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return featureNames.length;
    }

    public static MiningModel encodeModel(HasBooster hasBooster, Schema schema) {
        Booster booster = hasBooster.getBooster();
        GBDT gbdt = booster.getGBDT();
        ArrayList<ContinuousFeature> lgbmFeatures = new ArrayList<ContinuousFeature>();
        List features = schema.getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Set featureCategories;
            Feature feature = (Feature)features.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            try {
                Method method = GBDT.class.getDeclaredMethod("getFeatureCategories", Integer.TYPE);
                method.setAccessible(true);
                featureCategories = (Set)method.invoke((Object)gbdt, i);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            OpType opType = featureCategories != null && featureCategories.size() > 0 ? OpType.CATEGORICAL : OpType.CONTINUOUS;
            SkLearnEncoder encoder = (SkLearnEncoder)continuousFeature.getEncoder();
            TypeDefinitionField field = encoder.getField(continuousFeature.getName());
            field.setOpType(opType);
            lgbmFeatures.add(continuousFeature);
        }
        Schema lgbmSchema = new Schema(schema.getLabel(), lgbmFeatures);
        MiningModel miningModel = gbdt.encodeMiningModel(lgbmSchema);
        return miningModel;
    }
}

