/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.MatrixUtil;
import sklearn.Classifier;
import sklearn.svm.SupportVectorMachineUtil;

public abstract class BaseLibSVMClassifier
extends Classifier {
    public BaseLibSVMClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    @Override
    public boolean hasProbabilityDistribution() {
        return false;
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<? extends Number> supportVectors = this.getSupportVectors();
        List<Integer> supportSizes = this.getSupportSizes();
        List<? extends Number> dualCoef = this.getDualCoef();
        List<? extends Number> intercept = this.getIntercept();
        int[] offsets = new int[supportSizes.size() + 1];
        for (int i = 0; i < supportSizes.size(); ++i) {
            offsets[i + 1] = offsets[i] + supportSizes.get(i);
        }
        VectorDictionary vectorDictionary = SupportVectorMachineUtil.encodeVectorDictionary(support, supportVectors, numberOfVectors, numberOfFeatures, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        Kernel kernel = SupportVectorMachineUtil.encodeKernel(this.getKernel(), this.getDegree(), this.getGamma(), this.getCoef0());
        ArrayList<SupportVectorMachine> supportVectorMachines = new ArrayList<SupportVectorMachine>();
        int i = 0;
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        int size = categoricalLabel.size();
        for (int first = 0; first < size; ++first) {
            for (int second = first + 1; second < size; ++second) {
                ArrayList<VectorInstance> svmVectorInstances = new ArrayList<VectorInstance>();
                svmVectorInstances.addAll(BaseLibSVMClassifier.slice(vectorInstances, offsets, first));
                svmVectorInstances.addAll(BaseLibSVMClassifier.slice(vectorInstances, offsets, second));
                ArrayList<Number> svmDualCoef = new ArrayList<Number>();
                svmDualCoef.addAll(BaseLibSVMClassifier.slice(MatrixUtil.getRow(dualCoef, size - 1, numberOfVectors, second - 1), offsets, first));
                svmDualCoef.addAll(BaseLibSVMClassifier.slice(MatrixUtil.getRow(dualCoef, size - 1, numberOfVectors, first), offsets, second));
                SupportVectorMachine supportVectorMachine = SupportVectorMachineUtil.encodeSupportVectorMachine(svmVectorInstances, svmDualCoef, (Number)Iterables.get(intercept, (int)i)).setTargetCategory(categoricalLabel.getValue(second)).setAlternateTargetCategory(categoricalLabel.getValue(first));
                supportVectorMachines.add(supportVectorMachine);
                ++i;
            }
        }
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Schema)schema), vectorDictionary, supportVectorMachines).setClassificationMethod(SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE).setKernel(kernel);
        return supportVectorMachineModel;
    }

    public String getKernel() {
        return (String)this.get("kernel");
    }

    public Integer getDegree() {
        return ValueUtil.asInteger((Number)((Number)this.get("degree")));
    }

    public Double getGamma() {
        return ValueUtil.asDouble((Number)((Number)this.get("_gamma")));
    }

    public Double getCoef0() {
        return ValueUtil.asDouble((Number)((Number)this.get("coef0")));
    }

    public List<Integer> getSupport() {
        return ValueUtil.asIntegers(ClassDictUtil.getArray(this, "support_"));
    }

    public List<? extends Number> getSupportVectors() {
        return ClassDictUtil.getArray(this, "support_vectors_");
    }

    public List<Integer> getSupportSizes() {
        return ValueUtil.asIntegers(ClassDictUtil.getArray(this, "n_support_"));
    }

    public List<? extends Number> getDualCoef() {
        return ClassDictUtil.getArray(this, "_dual_coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "_intercept_");
    }

    private int[] getSupportVectorsShape() {
        return ClassDictUtil.getShape(this, "support_vectors_", 2);
    }

    private static <E> List<E> slice(List<E> list, int[] offsets, int index) {
        return list.subList(offsets[index], offsets[index + 1]);
    }
}

