/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import java.util.List;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static int getNumberOfFeatures(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        Learner learner = booster.getLearner();
        return learner.getNumFeatures();
    }

    public static MiningModel encodeBooster(HasBooster hasBooster, Schema schema) {
        Booster booster = hasBooster.getBooster();
        Learner learner = booster.getLearner();
        Schema xgbSchema = XGBoostUtil.toXGBoostSchema((Schema)schema);
        List features = xgbSchema.getFeatures();
        for (Feature feature : features) {
            SkLearnEncoder encoder;
            TypeDefinitionField field;
            if (!(feature instanceof ContinuousFeature) || OpType.CONTINUOUS.equals((Object)(field = (encoder = (SkLearnEncoder)feature.getEncoder()).getField(feature.getName())).getOpType())) continue;
            field.setOpType(OpType.CONTINUOUS);
        }
        MiningModel miningModel = learner.encodeMiningModel(xgbSchema);
        return miningModel;
    }
}

