/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.ClassDictUtil;

public class SkLearnEncoder
extends ModelEncoder {
    private List<String> ids = new ArrayList<String>();
    private List<Feature> features = new ArrayList<Feature>();

    public void updateType(FieldName name, OpType opType, DataType dataType) {
        TypeDefinitionField field = this.getField(name);
        if (opType != null) {
            field.setOpType(opType);
        }
        if (dataType != null) {
            field.setDataType(dataType);
        }
    }

    public void updateValueSpace(FieldName name, List<String> categories) {
        DataField dataField = this.getDataField(name);
        if (dataField == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        List existingCategories = PMMLUtil.getValues((DataField)dataField);
        if (existingCategories != null && existingCategories.size() > 0) {
            if (existingCategories.equals(categories)) {
                return;
            }
            throw new IllegalArgumentException("Data field " + name.getValue() + " has valid values " + existingCategories);
        }
        PMMLUtil.addValues((DataField)dataField, categories);
    }

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void addRow(List<String> ids, List<Feature> features) {
        ClassDictUtil.checkSize(ids, features);
        this.ids.addAll(ids);
        this.features.addAll(features);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }
}

