/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Selector;

public class SelectKBest
extends Selector {
    public SelectKBest(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<? extends Number> scores = this.getScores();
        return scores.size();
    }

    @Override
    public int[] selectFeatures(List<Feature> features) {
        Entry entry;
        Object k = this.getK();
        List<? extends Number> scores = this.getScores();
        ClassDictUtil.checkSize(features, scores);
        if ("all".equals(k)) {
            return null;
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < scores.size(); ++i) {
            Number score = scores.get(i);
            entry = new Entry(i, score.doubleValue());
            entries.add(entry);
        }
        Collections.sort(entries, Collections.reverseOrder());
        int[] result = new int[ValueUtil.asInt((Number)((Number)k))];
        for (int i = 0; i < result.length; ++i) {
            entry = (Entry)entries.get(i);
            result[i] = (Integer)entry.getId();
        }
        Arrays.sort(result);
        return result;
    }

    public Object getK() {
        return this.get("k");
    }

    public List<? extends Number> getScores() {
        return ClassDictUtil.getArray(this, "scores_");
    }

    private static class Entry<E>
    implements Comparable<Entry<E>> {
        private E id;
        private double score;

        public Entry(E id, double score) {
            this.setId(id);
            this.setScore(score);
        }

        @Override
        public int compareTo(Entry<E> that) {
            return Double.compare(this.getScore(), that.getScore());
        }

        public E getId() {
            return this.id;
        }

        private void setId(E id) {
            this.id = id;
        }

        public double getScore() {
            return this.score;
        }

        private void setScore(double score) {
            this.score = score;
        }
    }
}

