/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedInts;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.razorvine.pickle.Unpickler;
import net.razorvine.serpent.Parser;
import net.razorvine.serpent.ast.Ast;
import numpy.DType;
import numpy.core.NDArray;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.TupleUtil;

public class NDArrayUtil {
    private static final byte[] MAGIC_STRING = new byte[]{-109, 78, 85, 77, 80, 89};

    private NDArrayUtil() {
    }

    public static int[] getShape(NDArray array) {
        Object[] shape = array.getShape();
        List<Object> values = Arrays.asList(shape);
        return Ints.toArray((Collection)ValueUtil.asIntegers(values));
    }

    public static List<?> getContent(NDArray array) {
        Object content = array.getContent();
        return NDArrayUtil.asJavaList(array, (List)content);
    }

    public static List<?> getContent(NDArray array, String key) {
        Map content = (Map)array.getContent();
        return NDArrayUtil.asJavaList(array, (List)content.get(key));
    }

    private static <E> List<E> asJavaList(NDArray array, List<E> values) {
        boolean fortranOrder = array.getFortranOrder();
        if (fortranOrder) {
            int[] shape = NDArrayUtil.getShape(array);
            switch (shape.length) {
                case 1: {
                    return values;
                }
                case 2: {
                    return NDArrayUtil.toJavaList(values, shape[0], shape[1]);
                }
            }
            throw new IllegalArgumentException();
        }
        return values;
    }

    private static <E> List<E> toJavaList(List<E> values, int rows, int columns) {
        ArrayList<E> result = new ArrayList<E>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            int row = i / columns;
            int column = i % columns;
            E value = values.get(column * rows + row);
            result.add(value);
        }
        return result;
    }

    public static NDArray parseNpy(InputStream is) throws IOException {
        byte[] magicBytes = new byte[MAGIC_STRING.length];
        ByteStreams.readFully((InputStream)is, (byte[])magicBytes);
        if (!Arrays.equals(magicBytes, MAGIC_STRING)) {
            throw new IOException();
        }
        int majorVersion = NDArrayUtil.readUnsignedByte(is);
        int minorVersion = NDArrayUtil.readUnsignedByte(is);
        if (majorVersion != 1 || minorVersion != 0) {
            throw new IOException();
        }
        int headerLength = NDArrayUtil.readUnsignedShort(is, ByteOrder.LITTLE_ENDIAN);
        if (headerLength < 0) {
            throw new IOException();
        }
        byte[] headerBytes = new byte[headerLength];
        ByteStreams.readFully((InputStream)is, (byte[])headerBytes);
        String header = new String(headerBytes);
        header = header.trim();
        Map<String, ?> headerDict = NDArrayUtil.parseDict(header);
        Object descr = headerDict.get("descr");
        Boolean fortranOrder = (Boolean)headerDict.get("fortran_order");
        Object[] shape = (Object[])headerDict.get("shape");
        byte[] data = ByteStreams.toByteArray((InputStream)is);
        NDArray array = new NDArray();
        array.__setstate__(new Object[]{Arrays.asList(majorVersion, minorVersion), shape, descr, fortranOrder, data});
        return array;
    }

    public static Object parseData(InputStream is, Object descr, Object[] shape) throws IOException {
        if (descr instanceof DType) {
            DType dType = (DType)((Object)descr);
            descr = dType.toDescr();
        }
        int length = 1;
        for (int i = 0; i < shape.length; ++i) {
            length *= ValueUtil.asInt((Number)((Number)shape[i]));
        }
        if (descr instanceof String) {
            return NDArrayUtil.parseArray(is, (String)descr, length);
        }
        List dims = (List)descr;
        LinkedHashMap result = new LinkedHashMap();
        List<Object[]> objects = NDArrayUtil.parseMultiArray(is, TupleUtil.extractElementList(dims, 1), length);
        for (int i = 0; i < dims.size(); ++i) {
            Object[] dim = (Object[])dims.get(i);
            result.put((String)dim[0], TupleUtil.extractElementList(objects, i));
        }
        return result;
    }

    public static List<Object> parseArray(InputStream is, String descr, int length) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>(length);
        TypeDescriptor descriptor = new TypeDescriptor(descr);
        while (result.size() < length) {
            Object element = descriptor.read(is);
            if (descriptor.isObject()) {
                NDArray array = (NDArray)element;
                result.addAll(NDArrayUtil.getContent(array));
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public static List<Object[]> parseMultiArray(InputStream is, List<String> descrs, int length) throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>(length);
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>();
        for (String descr : descrs) {
            TypeDescriptor descriptor = new TypeDescriptor(descr);
            if (descriptor.isObject()) {
                throw new IllegalArgumentException(descr);
            }
            descriptors.add(descriptor);
        }
        for (int i = 0; i < length; ++i) {
            Object[] element = new Object[descriptors.size()];
            for (int j = 0; j < descriptors.size(); ++j) {
                TypeDescriptor descriptor = (TypeDescriptor)descriptors.get(j);
                element[j] = descriptor.read(is);
            }
            result.add(element);
        }
        return result;
    }

    private static Map<String, ?> parseDict(String string) {
        Parser parser = new Parser();
        Ast ast = parser.parse(string);
        return (Map)ast.getData();
    }

    private static byte readByte(InputStream is) throws IOException {
        int b = is.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    private static int readUnsignedByte(InputStream is) throws IOException {
        int b = is.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    private static int readUnsignedShort(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)0, (byte)0, (byte)b1, (byte)b2);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)0, (byte)0, (byte)b2, (byte)b1);
        }
        throw new IOException();
    }

    private static int readInt(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        byte b3 = NDArrayUtil.readByte(is);
        byte b4 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)b1, (byte)b2, (byte)b3, (byte)b4);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Ints.fromBytes((byte)b4, (byte)b3, (byte)b2, (byte)b1);
        }
        throw new IOException();
    }

    private static long readLong(InputStream is, ByteOrder byteOrder) throws IOException {
        byte b1 = NDArrayUtil.readByte(is);
        byte b2 = NDArrayUtil.readByte(is);
        byte b3 = NDArrayUtil.readByte(is);
        byte b4 = NDArrayUtil.readByte(is);
        byte b5 = NDArrayUtil.readByte(is);
        byte b6 = NDArrayUtil.readByte(is);
        byte b7 = NDArrayUtil.readByte(is);
        byte b8 = NDArrayUtil.readByte(is);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return Longs.fromBytes((byte)b1, (byte)b2, (byte)b3, (byte)b4, (byte)b5, (byte)b6, (byte)b7, (byte)b8);
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Longs.fromBytes((byte)b8, (byte)b7, (byte)b6, (byte)b5, (byte)b4, (byte)b3, (byte)b2, (byte)b1);
        }
        throw new IOException();
    }

    private static float readFloat(InputStream is, ByteOrder byteOrder) throws IOException {
        return Float.intBitsToFloat(NDArrayUtil.readInt(is, byteOrder));
    }

    private static double readDouble(InputStream is, ByteOrder byteOrder) throws IOException {
        return Double.longBitsToDouble(NDArrayUtil.readLong(is, byteOrder));
    }

    private static Object readObject(InputStream is) throws IOException {
        Unpickler unpickler = new Unpickler();
        return unpickler.load(is);
    }

    private static String readString(InputStream is, int size) throws IOException {
        byte[] buffer = new byte[size];
        ByteStreams.readFully((InputStream)is, (byte[])buffer);
        return NDArrayUtil.toString(buffer, "UTF-8");
    }

    private static String readUnicode(InputStream is, ByteOrder byteOrder, int size) throws IOException {
        byte[] buffer = new byte[size * 4];
        ByteStreams.readFully((InputStream)is, (byte[])buffer);
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toString(buffer, "UTF-32BE");
        }
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return NDArrayUtil.toString(buffer, "UTF-32LE");
        }
        throw new IOException();
    }

    private static String toString(byte[] buffer, String encoding) throws IOException {
        String string = new String(buffer, encoding);
        while (string.length() > 0 && string.charAt(string.length() - 1) == '\u0000') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static class TypeDescriptor {
        private ByteOrder byteOrder = null;
        private Kind kind = null;
        private int size = 0;

        private TypeDescriptor(String descr) {
            int i = 0;
            ByteOrder byteOrder = null;
            switch (descr.charAt(i)) {
                case '=': {
                    byteOrder = ByteOrder.nativeOrder();
                    ++i;
                    break;
                }
                case '>': {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    ++i;
                    break;
                }
                case '<': {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    ++i;
                    break;
                }
                case '|': {
                    ++i;
                }
            }
            this.setByteOrder(byteOrder);
            Kind kind = Kind.forChar(descr.charAt(i));
            this.setKind(kind);
            if (++i < descr.length()) {
                int size = Integer.parseInt(descr.substring(i));
                this.setSize(size);
            }
        }

        public Object read(InputStream is) throws IOException {
            Kind kind = this.getKind();
            ByteOrder byteOrder = this.getByteOrder();
            int size = this.getSize();
            switch (kind) {
                case BOOLEAN: {
                    switch (size) {
                        case 1: {
                            return NDArrayUtil.readByte(is) == 1;
                        }
                    }
                    break;
                }
                case INTEGER: {
                    switch (size) {
                        case 4: {
                            return NDArrayUtil.readInt(is, byteOrder);
                        }
                        case 8: {
                            return NDArrayUtil.readLong(is, byteOrder);
                        }
                    }
                    break;
                }
                case UNSIGNED_INTEGER: {
                    switch (size) {
                        case 4: {
                            return UnsignedInts.toLong((int)NDArrayUtil.readInt(is, byteOrder));
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (size) {
                        case 4: {
                            return Float.valueOf(NDArrayUtil.readFloat(is, byteOrder));
                        }
                        case 8: {
                            return NDArrayUtil.readDouble(is, byteOrder);
                        }
                    }
                    break;
                }
                case OBJECT: {
                    return NDArrayUtil.readObject(is);
                }
                case STRING: {
                    return NDArrayUtil.readString(is, size);
                }
                case UNICODE: {
                    return NDArrayUtil.readUnicode(is, byteOrder, size);
                }
                case VOID: {
                    byte[] buffer = new byte[size];
                    ByteStreams.readFully((InputStream)is, (byte[])buffer);
                    return buffer;
                }
            }
            throw new IOException();
        }

        public boolean isObject() {
            Kind kind = this.getKind();
            switch (kind) {
                case OBJECT: {
                    return true;
                }
            }
            return false;
        }

        public ByteOrder getByteOrder() {
            return this.byteOrder;
        }

        private void setByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
        }

        public Kind getKind() {
            return this.kind;
        }

        private void setKind(Kind kind) {
            this.kind = kind;
        }

        public int getSize() {
            return this.size;
        }

        private void setSize(int size) {
            this.size = size;
        }

        private static enum Kind {
            BOOLEAN,
            INTEGER,
            UNSIGNED_INTEGER,
            FLOAT,
            COMPLEX_FLOAT,
            OBJECT,
            STRING,
            UNICODE,
            VOID;


            public static Kind forChar(char c) {
                switch (c) {
                    case 'b': {
                        return BOOLEAN;
                    }
                    case 'i': {
                        return INTEGER;
                    }
                    case 'u': {
                        return UNSIGNED_INTEGER;
                    }
                    case 'f': {
                        return FLOAT;
                    }
                    case 'c': {
                        return COMPLEX_FLOAT;
                    }
                    case 'O': {
                        return OBJECT;
                    }
                    case 'S': 
                    case 'a': {
                        return STRING;
                    }
                    case 'U': {
                        return UNICODE;
                    }
                    case 'V': {
                        return VOID;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }
}

