/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.Extension;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.PickleUtil;
import org.jpmml.sklearn.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn2pmml.PMMLPipeline;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, description="Pickle input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    @Parameter(names={"--repr-pipeline", "--repr"}, description="String representation", hidden=true)
    private String repr = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        long end;
        Object object;
        PickleUtil.init();
        try (Storage storage = PickleUtil.createStorage(this.input);){
            logger.info("Parsing PKL..");
            long start = System.currentTimeMillis();
            object = PickleUtil.unpickle(storage);
            end = System.currentTimeMillis();
            logger.info("Parsed PKL in {} ms.", (Object)(end - start));
        }
        catch (Exception e) {
            logger.error("Failed to parse PKL", (Throwable)e);
            throw e;
        }
        if (!(object instanceof PMMLPipeline)) {
            throw new IllegalArgumentException("The object (" + ClassDictUtil.formatClass(object) + ") is not a PMMLPipeline");
        }
        PMMLPipeline pipeline = (PMMLPipeline)object;
        try {
            logger.info("Converting..");
            long begin = System.currentTimeMillis();
            pmml = pipeline.encodePMML();
            end = System.currentTimeMillis();
            logger.info("Converted in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert", (Throwable)e);
            throw e;
        }
        if (this.repr != null) {
            MiningBuildTask miningBuildTask = pmml.getMiningBuildTask();
            if (miningBuildTask == null) {
                miningBuildTask = new MiningBuildTask();
                pmml.setMiningBuildTask(miningBuildTask);
            }
            Extension extension = new Extension().addContent(new Object[]{this.repr});
            miningBuildTask.addExtensions(new Extension[]{extension});
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long start = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - start));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getRepr() {
        return this.repr;
    }

    public void setRepr(String repr) {
        this.repr = repr;
    }
}

