/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import joblib.NDArrayWrapperConstructor;
import joblib.NumpyArrayWrapper;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.Unpickler;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import org.jpmml.sklearn.CClassDict;
import org.jpmml.sklearn.CompressedInputStreamStorage;
import org.jpmml.sklearn.ExtensionObjectConstructor;
import org.jpmml.sklearn.FileStorage;
import org.jpmml.sklearn.ObjectConstructor;
import org.jpmml.sklearn.Storage;

public class PickleUtil {
    private PickleUtil() {
    }

    public static void init() throws Exception {
        Thread thread = Thread.currentThread();
        PickleUtil.init(thread.getContextClassLoader());
    }

    public static void init(ClassLoader classLoader) throws Exception {
        ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
        ImmutableSet resources = classPath.getResources();
        for (ClassPath.ResourceInfo resource : resources) {
            String resourceName = resource.getResourceName();
            if (!"META-INF/sklearn2pmml.properties".equals(resourceName)) continue;
            Properties properties = new Properties();
            URL url = resource.url();
            try (InputStream is = url.openStream();){
                properties.load(is);
            }
            Set<String> keys = properties.stringPropertyNames();
            for (String key : keys) {
                ObjectConstructor constructor;
                String value = properties.getProperty(key);
                int dot = key.lastIndexOf(46);
                if (dot < 0) {
                    throw new IllegalArgumentException(key);
                }
                String module = key.substring(0, dot);
                String name = key.substring(dot + 1);
                Class<?> clazz = classLoader.loadClass(value);
                if (CClassDict.class.isAssignableFrom(clazz)) {
                    constructor = new ExtensionObjectConstructor(module, name, (Class<? extends CClassDict>)clazz);
                } else if (ClassDict.class.isAssignableFrom(clazz)) {
                    constructor = new ObjectConstructor(module, name, clazz);
                } else {
                    throw new IllegalArgumentException(value);
                }
                Unpickler.registerConstructor((String)constructor.getModule(), (String)constructor.getName(), (IObjectConstructor)constructor);
            }
        }
    }

    public static Storage createStorage(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                return new CompressedInputStreamStorage(is);
            }
            catch (IOException ioe) {
                ((InputStream)is).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new FileStorage(file);
    }

    public static Object unpickle(Storage storage) throws IOException {
        ObjectConstructor[] constructors;
        for (ObjectConstructor constructor : constructors = new ObjectConstructor[]{new NDArrayWrapperConstructor("joblib.numpy_pickle", "NDArrayWrapper", storage), new NDArrayWrapperConstructor("sklearn.externals.joblib.numpy_pickle", "NDArrayWrapper", storage)}) {
            Unpickler.registerConstructor((String)constructor.getModule(), (String)constructor.getName(), (IObjectConstructor)constructor);
        }
        try (final InputStream is = storage.getObject();){
            Unpickler unpickler = new Unpickler(){

                protected Object dispatch(short key) throws IOException {
                    Object head;
                    Object result = super.dispatch(key);
                    if (key == 98 && (head = this.stack.peek()) instanceof NumpyArrayWrapper) {
                        NumpyArrayWrapper arrayWrapper = (NumpyArrayWrapper)((Object)head);
                        this.stack.pop();
                        NDArray array = arrayWrapper.toArray(is);
                        this.stack.add((Object)array);
                    }
                    return result;
                }
            };
            Object object = unpickler.load(is);
            return object;
        }
    }
}

