/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasClasses;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class Pipeline
extends Estimator
implements HasClasses {
    public Pipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public MiningFunction getMiningFunction() {
        Estimator estimator = this.getEstimator();
        return estimator.getMiningFunction();
    }

    @Override
    public boolean isSupervised() {
        Estimator estimator = this.getEstimator();
        return estimator.isSupervised();
    }

    @Override
    public int getNumberOfFeatures() {
        List<Transformer> transformers = this.getTransformers();
        Estimator estimator = this.getEstimator();
        for (Transformer transformer : transformers) {
            if (!(transformer instanceof HasNumberOfFeatures)) continue;
            HasNumberOfFeatures hasNumberOfFeatures = (HasNumberOfFeatures)((Object)transformer);
            return hasNumberOfFeatures.getNumberOfFeatures();
        }
        return estimator.getNumberOfFeatures();
    }

    @Override
    public OpType getOpType() {
        List<Transformer> transformers = this.getTransformers();
        Estimator estimator = this.getEstimator();
        for (Transformer transformer : transformers) {
            OpType opType = transformer.getOpType();
            if (opType == null) continue;
            return opType;
        }
        return estimator.getOpType();
    }

    @Override
    public DataType getDataType() {
        List<Transformer> transformers = this.getTransformers();
        Estimator estimator = this.getEstimator();
        for (Transformer transformer : transformers) {
            DataType dataType = transformer.getDataType();
            if (dataType == null) continue;
            return dataType;
        }
        return estimator.getDataType();
    }

    @Override
    public List<?> getClasses() {
        Estimator estimator = this.getEstimator();
        return EstimatorUtil.getClasses(estimator);
    }

    @Override
    public Model encodeModel(Schema schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model encodeModel(Schema schema, SkLearnEncoder encoder) {
        List<Transformer> transformers = this.getTransformers();
        Estimator estimator = this.getEstimator();
        if (transformers.size() > 0) {
            List<String> ids = encoder.getIds();
            List<Feature> features = encoder.getFeatures();
            for (Transformer transformer : transformers) {
                HasNumberOfFeatures hasNumberOfFeatures;
                int numberOfFeatures;
                if (transformer instanceof HasNumberOfFeatures && (numberOfFeatures = (hasNumberOfFeatures = (HasNumberOfFeatures)((Object)transformer)).getNumberOfFeatures()) > -1) {
                    ClassDictUtil.checkSize(numberOfFeatures, ids, features);
                }
                for (Feature feature : features) {
                    encoder.updateType(feature.getName(), transformer.getOpType(), transformer.getDataType());
                }
                features = transformer.encodeFeatures(ids, features, encoder);
            }
            schema = new Schema(schema.getLabel(), features);
        }
        List features = schema.getFeatures();
        int numberOfFeatures = estimator.getNumberOfFeatures();
        if (numberOfFeatures > -1) {
            ClassDictUtil.checkSize(numberOfFeatures, features);
        }
        return estimator.encodeModel(schema, encoder);
    }

    public List<Transformer> getTransformers() {
        List<Object[]> transformerSteps = this.getTransformerSteps();
        return TransformerUtil.asTransformerList(TupleUtil.extractElementList(transformerSteps, 1));
    }

    public List<Object[]> getTransformerSteps() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException("Missing estimator step");
        }
        return steps.subList(0, steps.size() - 1);
    }

    public Estimator getEstimator() {
        Object[] estimatorStep = this.getEstimatorStep();
        return EstimatorUtil.asEstimator(TupleUtil.extractElement(estimatorStep, 1));
    }

    protected Object[] getEstimatorStep() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException("Missing estimator step");
        }
        return steps.get(steps.size() - 1);
    }

    public List<Object[]> getSteps() {
        return (List)this.get("steps");
    }
}

