/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import numpy.core.UFunc;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class FunctionTransformer
extends Transformer {
    public FunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        UFunc ufunc;
        Object func = this.getFunc();
        ClassDictUtil.checkSize(ids, features);
        try {
            ufunc = (UFunc)((Object)func);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("The function object (" + ClassDictUtil.formatClass(func) + ") is not a Numpy universal function", cce);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            String id = ids.get(i);
            Feature feature = features.get(i);
            Expression expression = FunctionTransformer.encodeUFunc(ufunc, feature.toContinuousFeature().ref());
            DerivedField derivedField = encoder.createDerivedField(FieldName.create((String)(ufunc.getName() + "(" + id + ")")), expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        return result;
    }

    public Object getFunc() {
        return this.get("func");
    }

    static Expression encodeUFunc(UFunc ufunc, FieldRef fieldRef) {
        String name;
        switch (name = ufunc.getName()) {
            case "absolute": {
                return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{fieldRef});
            }
            case "ceil": 
            case "exp": 
            case "floor": {
                return PMMLUtil.createApply((String)name, (Expression[])new Expression[]{fieldRef});
            }
            case "log": {
                return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{fieldRef});
            }
            case "log10": {
                return PMMLUtil.createApply((String)name, (Expression[])new Expression[]{fieldRef});
            }
            case "negative": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)-1), fieldRef});
            }
            case "reciprocal": {
                return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Object)1), fieldRef});
            }
            case "sign": {
                return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Object)0)}), PMMLUtil.createConstant((Object)-1), PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Object)0)}), PMMLUtil.createConstant((Object)1), PMMLUtil.createConstant((Object)0)})});
            }
            case "sqrt": {
                return PMMLUtil.createApply((String)name, (Expression[])new Expression[]{fieldRef});
            }
            case "square": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{fieldRef, fieldRef});
            }
        }
        switch (name) {
            case "asin": 
            case "acos": 
            case "atan": 
            case "atan2": 
            case "cos": 
            case "cosh": 
            case "expm1": 
            case "hypot": 
            case "ln1p": 
            case "rint": 
            case "sin": 
            case "sinh": 
            case "tan": 
            case "tanh": {
                return PMMLUtil.createApply((String)("x-" + name), (Expression[])new Expression[]{fieldRef});
            }
        }
        throw new IllegalArgumentException(name);
    }
}

