/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class Imputer
extends Transformer {
    public Imputer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> statistics = this.getStatistics();
        ClassDictUtil.checkSize(ids, features, statistics);
        Object missingValues = this.getMissingValues();
        Number targetValue = Imputer.getTargetValue(missingValues);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            String id = ids.get(i);
            Feature feature = features.get(i);
            Number statisticValue = statistics.get(i);
            TypeDefinitionField field = encoder.getField(feature.getName());
            if (field instanceof DataField) {
                String strategy = this.getStrategy();
                MissingValueDecorator decorator = new MissingValueDecorator().setMissingValueReplacement(ValueUtil.formatValue((Number)statisticValue)).setMissingValueTreatment(Imputer.parseStrategy(strategy));
                if (targetValue != null) {
                    decorator.addValues(new String[]{ValueUtil.formatValue((Number)targetValue)});
                }
                encoder.addDecorator(feature.getName(), (Decorator)decorator);
                result.add(feature);
                continue;
            }
            FieldRef expression = feature.ref();
            expression = targetValue == null ? PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression}) : PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)targetValue)});
            expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)statisticValue), feature.ref()});
            DerivedField derivedField = encoder.createDerivedField(this.createName(id), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        return result;
    }

    public Object getMissingValues() {
        return this.get("missing_values");
    }

    public List<? extends Number> getStatistics() {
        return ClassDictUtil.getArray(this, "statistics_");
    }

    public String getStrategy() {
        return (String)this.get("strategy");
    }

    private static Number getTargetValue(Object object) {
        if (object instanceof String) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new IllegalArgumentException();
    }

    private static MissingValueTreatmentMethod parseStrategy(String strategy) {
        switch (strategy) {
            case "mean": {
                return MissingValueTreatmentMethod.AS_MEAN;
            }
            case "median": {
                return MissingValueTreatmentMethod.AS_MEDIAN;
            }
            case "most_frequent": {
                return MissingValueTreatmentMethod.AS_MODE;
            }
        }
        throw new IllegalArgumentException(strategy);
    }
}

