/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.PowerFeature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class PolynomialFeatures
extends Transformer {
    public PolynomialFeatures(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, final SkLearnEncoder encoder) {
        int i;
        int numberOfInputFeatures = this.getNumberOfInputFeatures();
        int numberOfOutputFeatures = this.getNumberOfOutputFeatures();
        ClassDictUtil.checkSize(numberOfInputFeatures, ids, features);
        final int degree = this.getDegree();
        boolean includeBias = this.getIncludeBias();
        boolean interactionOnly = this.getInteractionOnly();
        ArrayList<int[]> powers = new ArrayList<int[]>();
        int n = i = includeBias ? 0 : 1;
        while (i <= degree) {
            List<int[]> degreePowers = interactionOnly ? PolynomialFeatures.combinations(numberOfInputFeatures, i) : PolynomialFeatures.combinations_with_replacement(numberOfInputFeatures, i);
            powers.addAll(degreePowers);
            ++i;
        }
        ClassDictUtil.checkSize(numberOfOutputFeatures, powers);
        FieldName unitName = FieldName.create((String)"constant(1.0d)");
        DerivedField unitField = encoder.getDerivedField(unitName);
        if (unitField == null) {
            unitField = encoder.createDerivedField(unitName, (Expression)PMMLUtil.createConstant((Object)1.0));
        }
        Function<Feature, Feature[]> function = new Function<Feature, Feature[]>(){

            public Feature[] apply(Feature feature) {
                Feature[] features = new Feature[degree];
                features[0] = feature;
                TypeDefinitionField field = encoder.getField(feature.getName());
                for (int i = 2; i <= degree; ++i) {
                    features[i - 1] = new PowerFeature((PMMLEncoder)encoder, field, i);
                }
                return features;
            }
        };
        ArrayList transformedFeatures = new ArrayList(Lists.transform(features, (Function)function));
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int[] power : powers) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            ArrayList<String> powerIds = new ArrayList<String>();
            ArrayList<Feature> powerFeatures = new ArrayList<Feature>();
            for (int i2 = 0; i2 < power.length; ++i2) {
                String id = ids.get(i2);
                Feature feature = features.get(i2);
                if (power[i2] < 1) continue;
                sb.append(sep);
                sep = ":";
                sb.append(id).append(power[i2] > 1 ? "^" + power[i2] : "");
                powerIds.add(id);
                powerFeatures.add(((Feature[])transformedFeatures.get(i2))[power[i2] - 1]);
            }
            if (powerFeatures.size() == 0) {
                ids.add(unitName.getValue());
                result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)unitField));
                continue;
            }
            if (powerFeatures.size() == 1) {
                ids.add((String)Iterables.getOnlyElement(powerIds));
                result.add((Feature)Iterables.getOnlyElement(powerFeatures));
                continue;
            }
            String id = sb.toString();
            ids.add(id);
            result.add((Feature)new InteractionFeature((PMMLEncoder)encoder, FieldName.create((String)id), DataType.DOUBLE, powerFeatures));
        }
        ids.subList(0, features.size()).clear();
        return result;
    }

    public int getDegree() {
        return ValueUtil.asInt((Number)((Number)this.get("degree")));
    }

    public boolean getIncludeBias() {
        return (Boolean)this.get("include_bias");
    }

    public boolean getInteractionOnly() {
        return (Boolean)this.get("interaction_only");
    }

    public int getNumberOfInputFeatures() {
        return ValueUtil.asInt((Number)((Number)this.get("n_input_features_")));
    }

    public int getNumberOfOutputFeatures() {
        return ValueUtil.asInt((Number)((Number)this.get("n_output_features_")));
    }

    private static List<int[]> combinations(int n, int r) {
        int i;
        ArrayList<int[]> result = new ArrayList<int[]>();
        int[] indices = new int[r];
        for (i = 0; i < r; ++i) {
            indices[i] = i;
        }
        result.add(PolynomialFeatures.power(n, indices));
        while (true) {
            for (i = r - 1; i > -1 && indices[i] == i + n - r; --i) {
            }
            if (i < 0) break;
            int n2 = i;
            indices[n2] = indices[n2] + 1;
            for (int j = i + 1; j < r; ++j) {
                indices[j] = indices[j - 1] + 1;
            }
            result.add(PolynomialFeatures.power(n, indices));
        }
        return result;
    }

    private static List<int[]> combinations_with_replacement(int n, int r) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int[] indices = new int[r];
        result.add(PolynomialFeatures.power(n, indices));
        while (true) {
            int i;
            for (i = r - 1; i > -1 && indices[i] == n - 1; --i) {
            }
            if (i < 0) break;
            int value = indices[i] + 1;
            for (int j = i; j < r; ++j) {
                indices[j] = value;
            }
            result.add(PolynomialFeatures.power(n, indices));
        }
        return result;
    }

    private static int[] power(int n, int[] indices) {
        int[] result = new int[n];
        int[] arr$ = indices;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int index;
            int n2 = index = arr$[i$];
            result[n2] = result[n2] + 1;
        }
        return result;
    }
}

