/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.LoggerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportVectorMachineUtil {
    private static final Logger logger = LoggerFactory.getLogger(SupportVectorMachineUtil.class);

    private SupportVectorMachineUtil() {
    }

    public static VectorDictionary encodeVectorDictionary(List<Integer> support, List<? extends Number> supportVectors, int numberOfVectors, int numberOfFeatures, Schema schema) {
        BitSet featureMask = new BitSet(numberOfFeatures);
        Double defaultValue = 0.0;
        for (int i = 0; i < numberOfVectors; ++i) {
            List values = CMatrixUtil.getRow(supportVectors, (int)numberOfVectors, (int)numberOfFeatures, (int)i);
            BitSet vectorFeatures = ValueUtil.getIndices((List)values, (Number)defaultValue);
            vectorFeatures.flip(0, numberOfFeatures);
            featureMask.or(vectorFeatures);
        }
        int numberOfUsedFeatures = featureMask.cardinality();
        ArrayList<Feature> unusedFeatures = new ArrayList<Feature>();
        VectorFields vectorFields = new VectorFields();
        for (int i = 0; i < numberOfFeatures; ++i) {
            Feature feature = schema.getFeature(i);
            if (!featureMask.get(i)) {
                unusedFeatures.add(feature);
                continue;
            }
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                CategoricalPredictor categoricalPredictor = new CategoricalPredictor(binaryFeature.getName(), binaryFeature.getValue(), 1.0);
                vectorFields.addContent(new PMMLObject[]{categoricalPredictor});
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            vectorFields.addContent(new PMMLObject[]{continuousFeature.ref()});
        }
        VectorDictionary vectorDictionary = new VectorDictionary(vectorFields);
        for (int i = 0; i < numberOfVectors; ++i) {
            String id = String.valueOf(support.get(i));
            VectorInstance vectorInstance = new VectorInstance(id);
            List values = CMatrixUtil.getRow(supportVectors, (int)numberOfVectors, (int)numberOfFeatures, (int)i);
            if (numberOfUsedFeatures < numberOfFeatures) {
                values = ValueUtil.filterByIndices((List)values, (BitSet)featureMask);
            }
            if (ValueUtil.isSparse((List)values, (Number)defaultValue, (double)0.75)) {
                RealSparseArray sparseArray = PMMLUtil.createRealSparseArray((List)values, (Double)defaultValue);
                vectorInstance.setRealSparseArray(sparseArray);
            } else {
                Array array = PMMLUtil.createRealArray((List)values);
                vectorInstance.setArray(array);
            }
            vectorDictionary.addVectorInstances(new VectorInstance[]{vectorInstance});
        }
        if (!unusedFeatures.isEmpty()) {
            logger.info("Skipped {} feature(s): {}", (Object)unusedFeatures.size(), (Object)LoggerUtil.formatNameList(unusedFeatures));
        }
        return vectorDictionary;
    }

    public static SupportVectorMachine encodeSupportVectorMachine(List<VectorInstance> vectorInstances, List<? extends Number> dualCoef, Number intercept) {
        ClassDictUtil.checkSize(vectorInstances, dualCoef);
        Coefficients coefficients = new Coefficients().setAbsoluteValue(ValueUtil.asDouble((Number)intercept));
        SupportVectors supportVectors = new SupportVectors();
        for (int i = 0; i < vectorInstances.size(); ++i) {
            VectorInstance vectorInstance = vectorInstances.get(i);
            Coefficient coefficient = new Coefficient().setValue(ValueUtil.asDouble((Number)dualCoef.get(i)));
            coefficients.addCoefficients(new Coefficient[]{coefficient});
            SupportVector supportVector = new SupportVector(vectorInstance.getId());
            supportVectors.addSupportVectors(new SupportVector[]{supportVector});
        }
        SupportVectorMachine supportVectorMachine = new SupportVectorMachine(coefficients).setSupportVectors(supportVectors);
        return supportVectorMachine;
    }

    public static Kernel encodeKernel(String kernel, Integer degree, Double gamma, Double coef0) {
        switch (kernel) {
            case "linear": {
                return new LinearKernel();
            }
            case "poly": {
                return new PolynomialKernel().setDegree(ValueUtil.asDouble((Number)degree)).setCoef0(coef0).setGamma(gamma);
            }
            case "rbf": {
                return new RadialBasisKernel().setGamma(gamma);
            }
            case "sigmoid": {
                return new SigmoidKernel().setCoef0(coef0).setGamma(gamma);
            }
        }
        throw new IllegalArgumentException(kernel);
    }
}

