/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import numpy.core.NDArray;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.TypeUtil;
import sklearn.pipeline.Pipeline;
import sklearn_pandas.DataFrameMapper;

public class PMMLPipeline
extends Pipeline {
    public PMMLPipeline() {
        super("sklearn2pmml", "PMMLPipeline");
    }

    public PMMLPipeline(String module, String name) {
        super(module, name);
    }

    public PMML encodePMML() {
        DataFrameMapper dataFrameMapper = this.getMapper();
        Estimator estimator = this.getEstimator();
        String repr = this.getRepr();
        while (estimator instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)estimator;
            estimator = pipeline.getEstimator();
        }
        SkLearnEncoder encoder = new SkLearnEncoder();
        ContinuousLabel label = null;
        if (estimator.isSupervised()) {
            String targetField = this.getTargetField();
            if (targetField == null) {
                targetField = "y";
            }
            MiningFunction miningFunction = estimator.getMiningFunction();
            switch (miningFunction) {
                case CLASSIFICATION: {
                    List<?> classes = EstimatorUtil.getClasses(estimator);
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CATEGORICAL, TypeUtil.getDataType(classes, DataType.STRING), PMMLPipeline.formatTargetCategories(classes));
                    label = new CategoricalLabel(dataField);
                    break;
                }
                case REGRESSION: {
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CONTINUOUS, DataType.DOUBLE);
                    label = new ContinuousLabel(dataField);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (dataFrameMapper != null) {
            dataFrameMapper.encodeFeatures(encoder);
        } else {
            List<String> activeFields = this.getActiveFields();
            if (activeFields == null) {
                activeFields = new ArrayList<String>();
                int max = this.getNumberOfFeatures();
                for (int i = 0; i < max; ++i) {
                    activeFields.add("x" + String.valueOf(i + 1));
                }
            }
            OpType opType = this.getOpType();
            DataType dataType = this.getDataType();
            for (String activeField : activeFields) {
                DataField dataField = encoder.createDataField(FieldName.create((String)activeField), opType, dataType);
                encoder.addRow(Collections.singletonList(activeField), Collections.singletonList(new WildcardFeature((PMMLEncoder)encoder, dataField)));
            }
        }
        Schema schema = new Schema(label, encoder.getFeatures());
        Model model = this.encodeModel(schema, encoder);
        PMML pmml = encoder.encodePMML(model);
        if (repr != null) {
            Extension extension = new Extension().addContent(new Object[]{repr});
            MiningBuildTask miningBuildTask = new MiningBuildTask().addExtensions(new Extension[]{extension});
            pmml.setMiningBuildTask(miningBuildTask);
        }
        return pmml;
    }

    public DataFrameMapper getMapper() {
        Object[] mapperStep = this.getMapperStep();
        if (mapperStep != null) {
            return (DataFrameMapper)((Object)TupleUtil.extractElement(mapperStep, 1));
        }
        return null;
    }

    public Object[] getMapperStep() {
        Object object;
        List<Object[]> transformerSteps = super.getTransformerSteps();
        if (transformerSteps.size() > 0 && (object = TupleUtil.extractElement(transformerSteps.get(0), 1)) instanceof DataFrameMapper) {
            return transformerSteps.get(0);
        }
        return null;
    }

    @Override
    public List<Object[]> getTransformerSteps() {
        Object object;
        List<Object[]> transformerSteps = super.getTransformerSteps();
        if (transformerSteps.size() > 0 && (object = TupleUtil.extractElement(transformerSteps.get(0), 1)) instanceof DataFrameMapper) {
            transformerSteps = transformerSteps.subList(1, transformerSteps.size());
        }
        return transformerSteps;
    }

    @Override
    public List<Object[]> getSteps() {
        return super.getSteps();
    }

    public PMMLPipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }

    public String getRepr() {
        return (String)this.get("repr_");
    }

    public PMMLPipeline setRepr(String repr) {
        this.put("repr_", repr);
        return this;
    }

    public List<String> getActiveFields() {
        if (!this.containsKey("active_fields")) {
            return null;
        }
        return ClassDictUtil.getArray(this, "active_fields");
    }

    public PMMLPipeline setActiveFields(List<String> activeFields) {
        NDArray array = new NDArray();
        array.put("data", activeFields);
        array.put("fortran_order", Boolean.FALSE);
        this.put("active_fields", array);
        return this;
    }

    public String getTargetField() {
        return (String)this.get("target_field");
    }

    public PMMLPipeline setTargetField(String targetField) {
        this.put("target_field", targetField);
        return this;
    }

    private static List<String> formatTargetCategories(List<?> objects) {
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                String targetCategory = ValueUtil.formatValue((Object)object);
                if (targetCategory == null || CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)targetCategory)) {
                    throw new IllegalArgumentException(targetCategory);
                }
                return targetCategory;
            }
        };
        return new ArrayList<String>(Lists.transform(objects, (Function)function));
    }
}

