/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.TypeUtil;
import sklearn2pmml.decoration.Domain;

public class CategoricalDomain
extends Domain {
    public CategoricalDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> data = this.getData();
        return TypeUtil.getDataType(data, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        List<?> data = this.getData();
        ClassDictUtil.checkSize(1, ids, features);
        WildcardFeature wildcardFeature = (WildcardFeature)features.get(0);
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                return ValueUtil.formatValue((Object)object);
            }
        };
        List categories = Lists.transform(data, (Function)function);
        CategoricalFeature categoricalFeature = wildcardFeature.toCategoricalFeature(categories);
        return super.encodeFeatures(ids, Collections.singletonList(categoricalFeature), encoder);
    }

    public List<?> getData() {
        return ClassDictUtil.getArray(this, "data_");
    }
}

