/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn2pmml.decoration.DomainUtil;

public abstract class Domain
extends Transformer {
    public Domain(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        MissingValueTreatmentMethod missingValueTreatment = DomainUtil.parseMissingValueTreatment(this.getMissingValueTreatment());
        Object missingValueReplacement = this.getMissingValueReplacement();
        if (missingValueReplacement != null && missingValueTreatment == null) {
            missingValueTreatment = MissingValueTreatmentMethod.AS_VALUE;
        }
        InvalidValueTreatmentMethod invalidValueTreatment = DomainUtil.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        for (Feature feature : features) {
            FieldName name = feature.getName();
            if (missingValueTreatment != null) {
                MissingValueDecorator missingValueDecorator = new MissingValueDecorator().setMissingValueTreatment(missingValueTreatment).setMissingValueReplacement(missingValueReplacement != null ? ValueUtil.formatValue((Object)missingValueReplacement) : null);
                encoder.addDecorator(name, (Decorator)missingValueDecorator);
            }
            if (invalidValueTreatment == null) continue;
            InvalidValueDecorator invalidValueDecorator = new InvalidValueDecorator().setInvalidValueTreatment(invalidValueTreatment);
            encoder.addDecorator(name, (Decorator)invalidValueDecorator);
        }
        return features;
    }

    public String getMissingValueTreatment() {
        return (String)this.get("missing_value_treatment");
    }

    public Object getMissingValueReplacement() {
        return this.get("missing_value_replacement");
    }

    public String getInvalidValueTreatment() {
        return (String)this.get("invalid_value_treatment");
    }
}

