/*
 * Decompiled with CFR 0.152.
 */
package sklearn_pandas;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Transformer;
import sklearn_pandas.TransformerPipeline;

public class DataFrameMapper
extends ClassDict {
    public DataFrameMapper(String module, String name) {
        super(module, name);
    }

    public void encodeFeatures(SkLearnEncoder encoder) {
        List<Object[]> steps = this.getFeatures();
        for (int row = 0; row < steps.size(); ++row) {
            Object[] step = steps.get(row);
            ArrayList<String> ids = new ArrayList<String>();
            List<Feature> features = new ArrayList<Feature>();
            List<String> names = DataFrameMapper.getNameList(step);
            for (String name : names) {
                ids.add(name);
                DataField dataField = encoder.createDataField(FieldName.create((String)name));
                WildcardFeature feature = new WildcardFeature((PMMLEncoder)encoder, dataField);
                features.add((Feature)feature);
            }
            List<Transformer> transformers = DataFrameMapper.getTransformerList(step);
            for (int column = 0; column < transformers.size(); ++column) {
                Transformer transformer = transformers.get(column);
                for (Feature feature : features) {
                    encoder.updateType(feature.getName(), transformer.getOpType(), transformer.getDataType());
                }
                features = transformer.encodeFeatures(ids, features, encoder);
            }
            encoder.addRow(ids, features);
        }
    }

    public List<Object[]> getFeatures() {
        return (List)this.get("features");
    }

    private static List<String> getNameList(Object[] feature) {
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                throw new IllegalArgumentException("The key object (" + ClassDictUtil.formatClass(object) + ") is not a String");
            }
        };
        try {
            if (feature[0] instanceof List) {
                return new ArrayList<String>(Lists.transform((List)((List)feature[0]), (Function)function));
            }
            return Collections.singletonList(function.apply(feature[0]));
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Invalid mapping key", re);
        }
    }

    private static List<Transformer> getTransformerList(Object[] feature) {
        Function<Object, Transformer> function = new Function<Object, Transformer>(){

            public Transformer apply(Object object) {
                if (object instanceof Transformer) {
                    return (Transformer)((Object)object);
                }
                throw new IllegalArgumentException("The value object (" + ClassDictUtil.formatClass(object) + ") is not a Transformer or is not a supported Transformer subclass");
            }
        };
        try {
            if (feature[1] == null) {
                return Collections.emptyList();
            }
            if (feature[1] instanceof TransformerPipeline) {
                TransformerPipeline transformerPipeline = (TransformerPipeline)((Object)feature[1]);
                List<Object[]> steps = transformerPipeline.getSteps();
                return new ArrayList<Transformer>(Lists.transform(TupleUtil.extractElementList(steps, 1), (Function)function));
            }
            if (feature[1] instanceof List) {
                return new ArrayList<Transformer>(Lists.transform((List)((List)feature[1]), (Function)function));
            }
            return Collections.singletonList(function.apply(feature[1]));
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Invalid mapping value", re);
        }
    }
}

