/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import joblib.NDArrayWrapper;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.sklearn.HasArray;

public class ClassDictUtil {
    private static final Joiner JOINER = Joiner.on((String)", ");

    private ClassDictUtil() {
    }

    public static List<?> getArray(ClassDict dict, String name) {
        Object object = dict.get((Object)name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayContent();
        }
        if (object instanceof Number) {
            return Collections.singletonList(object);
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static List<?> getArray(ClassDict dict, String name, String key) {
        Object object = dict.get((Object)name);
        if (object instanceof NDArrayWrapper) {
            NDArrayWrapper arrayWrapper = (NDArrayWrapper)object;
            object = arrayWrapper.getContent();
        }
        if (object instanceof NDArray) {
            NDArray array = (NDArray)object;
            return NDArrayUtil.getContent(array, key);
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static int[] getShape(ClassDict dict, String name, int length) {
        int[] shape = ClassDictUtil.getShape(dict, name);
        if (shape.length != length) {
            throw new IllegalArgumentException("The dimensionality of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + shape.length + ") is not " + length);
        }
        return shape;
    }

    public static int[] getShape(ClassDict dict, String name) {
        Object object = dict.get((Object)name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayShape();
        }
        if (object instanceof Number) {
            return new int[]{1};
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static void checkSize(Collection<?> ... collections) {
        Collection<?> prevCollection = null;
        for (Collection<?> collection : collections) {
            if (collection == null) continue;
            if (prevCollection != null && collection.size() != prevCollection.size()) {
                throw new IllegalArgumentException("Expected the same number of elements, got different numbers of elements");
            }
            prevCollection = collection;
        }
    }

    public static void checkSize(int size, Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (collection == null || collection.size() == size) continue;
            throw new IllegalArgumentException("Expected " + size + " element(s), got " + collection.size() + " element(s)");
        }
    }

    public static String formatMember(ClassDict dict, String name) {
        String clazz = (String)dict.get((Object)"__class__");
        return clazz + "." + name;
    }

    public static String formatClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClassDict) {
            ClassDict dict = (ClassDict)object;
            String clazz = (String)dict.get((Object)"__class__");
            return "Python class " + clazz;
        }
        Class<?> clazz = object.getClass();
        return "Java class " + clazz.getName();
    }

    public static String formatFeatureList(List<Feature> features) {
        Function<Feature, FieldName> function = new Function<Feature, FieldName>(){

            public FieldName apply(Feature feature) {
                if (feature instanceof HasDerivedName) {
                    HasDerivedName hasDerivedName = (HasDerivedName)feature;
                    return hasDerivedName.getDerivedName();
                }
                return feature.getName();
            }
        };
        return ClassDictUtil.formatNameList(Lists.transform(features, (Function)function));
    }

    public static String formatNameList(List<FieldName> names) {
        Function<FieldName, String> function = new Function<FieldName, String>(){

            public String apply(FieldName name) {
                return name.getValue();
            }
        };
        return ClassDictUtil.formatIdList(Lists.transform(names, (Function)function));
    }

    public static String formatIdList(List<String> ids) {
        if (ids.size() > 5) {
            ArrayList<String> headTailValues = new ArrayList<String>(5);
            headTailValues.addAll(ids.subList(0, 2));
            headTailValues.add("..");
            headTailValues.addAll(ids.subList(ids.size() - 2, ids.size()));
            ids = headTailValues;
        }
        return JOINER.join(ids);
    }

    public static String toString(ClassDict dict) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n{\n");
        String sep = "";
        ArrayList entries = new ArrayList(dict.entrySet());
        Comparator comparator = new Comparator<Map.Entry<String, ?>>(){

            @Override
            public int compare(Map.Entry<String, ?> left, Map.Entry<String, ?> right) {
                return left.getKey().compareToIgnoreCase(right.getKey());
            }
        };
        Collections.sort(entries, comparator);
        for (Map.Entry entry : entries) {
            sb.append(sep);
            sep = "\n";
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append("\t" + key + "=" + value + " // " + (value != null ? value.getClass().getName() : "N/A"));
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

