/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLinearUtil {
    private static final Logger logger = LoggerFactory.getLogger(BaseLinearUtil.class);

    private BaseLinearUtil() {
    }

    public static RegressionModel encodeRegressionModel(Number intercept, List<? extends Number> coefficients, Schema schema) {
        List features = schema.getFeatures();
        ClassDictUtil.checkSize(features, coefficients);
        ArrayList<Feature> unusedFeatures = new ArrayList<Feature>();
        ArrayList<Double> featureCoefficients = new ArrayList<Double>(ValueUtil.asDoubles(coefficients));
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = (Feature)features.get(i);
            Double featureCoefficient = (Double)featureCoefficients.get(i);
            if (!ValueUtil.isZero((Number)featureCoefficient)) continue;
            featureCoefficients.set(i, Double.NaN);
            unusedFeatures.add(feature);
        }
        RegressionModel regressionModel = new RegressionModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema), null).addRegressionTables(new RegressionTable[]{RegressionModelUtil.createRegressionTable((List)features, (Double)ValueUtil.asDouble((Number)intercept), featureCoefficients)});
        if (!unusedFeatures.isEmpty()) {
            logger.info("Skipped {} feature(s): {}", (Object)unusedFeatures.size(), (Object)ClassDictUtil.formatFeatureList(unusedFeatures));
        }
        return regressionModel;
    }
}

