/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LabelBinarizer
extends Transformer {
    public LabelBinarizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        List<?> classes = this.getClasses();
        Number posLabel = this.getPosLabel();
        Number negLabel = this.getNegLabel();
        ClassDictUtil.checkSize(1, ids, features);
        String id = ids.get(0);
        Feature feature = features.get(0);
        ArrayList<String> categories = new ArrayList<String>();
        ids.clear();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < classes.size(); ++i) {
            Object value = classes.get(i);
            ids.add(id + "=" + ValueUtil.formatValue(value));
            if (ValueUtil.isOne((Number)posLabel) && ValueUtil.isZero((Number)negLabel)) {
                String category = ValueUtil.formatValue(value);
                categories.add(category);
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature.getName(), DataType.STRING, category));
                continue;
            }
            Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{feature.ref(), PMMLUtil.createConstant(value)}), PMMLUtil.createConstant((Object)posLabel), PMMLUtil.createConstant((Object)negLabel)});
            DerivedField derivedField = encoder.createDerivedField(this.createName(id, i), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        encoder.updateValueSpace(feature.getName(), categories);
        return result;
    }

    public List<?> getClasses() {
        return ClassDictUtil.getArray(this, "classes_");
    }

    public Number getPosLabel() {
        return (Number)this.get("pos_label");
    }

    public Number getNegLabel() {
        return (Number)this.get("neg_label");
    }
}

