/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class MaxAbsScaler
extends Transformer {
    public MaxAbsScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> ids, List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> scale = this.getScale();
        ClassDictUtil.checkSize(ids, features, scale);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            String id = ids.get(i);
            Feature feature = features.get(i);
            Number value = scale.get(i);
            if (ValueUtil.isOne((Number)value)) {
                result.add(feature);
                continue;
            }
            Apply apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{feature.toContinuousFeature().ref(), PMMLUtil.createConstant((Object)value)});
            DerivedField derivedField = encoder.createDerivedField(this.createName(id), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        return result;
    }

    public List<? extends Number> getScale() {
        return ClassDictUtil.getArray(this, "scale_");
    }
}

