/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.HasClasses;
import sklearn.Regressor;

public class EstimatorUtil {
    private static final Function<Object, Estimator> estimatorFunction = new Function<Object, Estimator>(){

        public Estimator apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Estimator)object;
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not an Estimator or is not a supported Estimator subclass", re);
            }
        }
    };
    private static final Function<Object, Classifier> classifierFunction = new Function<Object, Classifier>(){

        public Classifier apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Classifier)object;
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not a Classifier or is not a supported Classifier subclass", re);
            }
        }
    };
    private static final Function<Object, Regressor> regressorFunction = new Function<Object, Regressor>(){

        public Regressor apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Regressor)object;
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(object) + ") is not a Regressor or is not a supported Regressor subclass", re);
            }
        }
    };

    private EstimatorUtil() {
    }

    public static List<?> getClasses(Estimator estimator) {
        HasClasses hasClasses = (HasClasses)((Object)estimator);
        return hasClasses.getClasses();
    }

    public static Estimator asEstimator(Object object) {
        return (Estimator)estimatorFunction.apply(object);
    }

    public static List<Estimator> asEstimatorList(List<?> objects) {
        return Lists.transform(objects, estimatorFunction);
    }

    public static Classifier asClassifier(Object object) {
        return (Classifier)classifierFunction.apply(object);
    }

    public static List<? extends Classifier> asClassifierList(List<?> objects) {
        return Lists.transform(objects, classifierFunction);
    }

    public static Regressor asRegressor(Object object) {
        return (Regressor)regressorFunction.apply(object);
    }

    public static List<? extends Regressor> asRegressorList(List<?> objects) {
        return Lists.transform(objects, regressorFunction);
    }

    public static void checkSize(int size, CategoricalLabel categoricalLabel) {
        if (categoricalLabel.size() != size) {
            throw new IllegalArgumentException("Expected " + size + " class(es), got " + categoricalLabel.size() + " class(es)");
        }
    }
}

