/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValidValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.decoration.Domain;

public class ContinuousDomain
extends Domain {
    public ContinuousDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> dataMin = this.getDataMin();
        List<? extends Number> dataMax = this.getDataMax();
        ClassDictUtil.checkSize(features, dataMin, dataMax);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            WildcardFeature wildcardFeature = (WildcardFeature)features.get(i);
            ContinuousFeature continuousFeature = wildcardFeature.toContinuousFeature();
            Interval interval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(ValueUtil.asDouble((Number)dataMin.get(i))).setRightMargin(ValueUtil.asDouble((Number)dataMax.get(i)));
            ValidValueDecorator validValueDecorator = new ValidValueDecorator().addIntervals(new Interval[]{interval});
            encoder.addDecorator(continuousFeature.getName(), (Decorator)validValueDecorator);
            result.add((Feature)continuousFeature);
        }
        return super.encodeFeatures(result, encoder);
    }

    public List<? extends Number> getDataMin() {
        return ClassDictUtil.getArray(this, "data_min_");
    }

    public List<? extends Number> getDataMax() {
        return ClassDictUtil.getArray(this, "data_max_");
    }
}

