/*
 * Decompiled with CFR 0.152.
 */
package sklearn_pandas;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Transformer;
import sklearn_pandas.TransformerPipeline;

public class DataFrameMapper
extends Transformer {
    public DataFrameMapper(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Object _default = this.getDefault();
        List<Object[]> rows = this.getFeatures();
        if (!Boolean.FALSE.equals(_default)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>(features);
        for (Object[] row : rows) {
            List<Feature> rowFeatures = new ArrayList<Feature>();
            List<String> columns = DataFrameMapper.getColumnList(row);
            for (String column : columns) {
                FieldName name = FieldName.create((String)column);
                DataField dataField = encoder.getDataField(name);
                if (dataField == null) {
                    dataField = encoder.createDataField(name);
                }
                rowFeatures.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
            }
            List<Transformer> transformers = DataFrameMapper.getTransformerList(row);
            for (Transformer transformer : transformers) {
                encoder.updateFeatures(rowFeatures, transformer, false);
                rowFeatures = transformer.encodeFeatures(rowFeatures, encoder);
            }
            result.addAll(rowFeatures);
        }
        return result;
    }

    public Object getDefault() {
        return this.get("default");
    }

    public DataFrameMapper setDefault(Object _default) {
        this.put("default", _default);
        return this;
    }

    public List<Object[]> getFeatures() {
        return (List)this.get("features");
    }

    public DataFrameMapper setFeatures(List<Object[]> features) {
        this.put("features", features);
        return this;
    }

    private static List<String> getColumnList(Object[] feature) {
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                throw new IllegalArgumentException("The key object (" + ClassDictUtil.formatClass(object) + ") is not a String");
            }
        };
        try {
            if (feature[0] instanceof HasArray) {
                HasArray hasArray = (HasArray)feature[0];
                return hasArray.getArrayContent();
            }
            if (feature[0] instanceof List) {
                return Lists.transform((List)((List)feature[0]), (Function)function);
            }
            return Collections.singletonList(function.apply(feature[0]));
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Invalid mapping key", re);
        }
    }

    private static List<Transformer> getTransformerList(Object[] feature) {
        Function<Object, Transformer> function = new Function<Object, Transformer>(){

            public Transformer apply(Object object) {
                if (object instanceof Transformer) {
                    return (Transformer)((Object)object);
                }
                throw new IllegalArgumentException("The value object (" + ClassDictUtil.formatClass(object) + ") is not a Transformer or is not a supported Transformer subclass");
            }
        };
        try {
            if (feature[1] == null) {
                return Collections.emptyList();
            }
            if (feature[1] instanceof TransformerPipeline) {
                TransformerPipeline transformerPipeline = (TransformerPipeline)((Object)feature[1]);
                List<Object[]> steps = transformerPipeline.getSteps();
                return Lists.transform(TupleUtil.extractElementList(steps, 1), (Function)function);
            }
            if (feature[1] instanceof List) {
                return Lists.transform((List)((List)feature[1]), (Function)function);
            }
            return Collections.singletonList(function.apply(feature[1]));
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Invalid mapping value", re);
        }
    }
}

