/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.WildcardFeature;
import sklearn.Transformer;

public class SkLearnEncoder
extends ModelEncoder {
    public void updateFeatures(List<Feature> features, Transformer transformer) {
        DataType dataType;
        OpType opType;
        try {
            opType = transformer.getOpType();
            dataType = transformer.getDataType();
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        for (Feature feature : features) {
            if (!(feature instanceof WildcardFeature)) continue;
            WildcardFeature wildcardFeature = (WildcardFeature)feature;
            this.updateType(wildcardFeature.getName(), opType, dataType);
        }
    }

    public void updateType(FieldName name, OpType opType, DataType dataType) {
        DataField dataField = this.getDataField(name);
        if (dataField == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        dataField.setOpType(opType);
        dataField.setDataType(dataType);
    }

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }
}

