/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;

public abstract class BaseLinearRegressor
extends Regressor {
    public BaseLinearRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[0];
    }

    public RegressionModel encodeModel(Schema schema) {
        List<? extends Number> coef = this.getCoef();
        List<? extends Number> intercept = this.getIntercept();
        RegressionModel regressionModel = new RegressionModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)schema), null).addRegressionTables(new RegressionTable[]{RegressionModelUtil.createRegressionTable((List)schema.getFeatures(), (Double)ValueUtil.asDouble((Number)((Number)Iterables.getOnlyElement(intercept))), (List)ValueUtil.asDoubles(coef))});
        return regressionModel;
    }

    public List<? extends Number> getCoef() {
        return ClassDictUtil.getArray(this, "coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "intercept_");
    }

    private int[] getCoefShape() {
        return ClassDictUtil.getShape(this, "coef_", 1);
    }
}

