/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class RobustScaler
extends Transformer
implements HasNumberOfFeatures {
    public RobustScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape;
        Boolean withCentering = this.getWithCentering();
        Boolean withScaling = this.getWithScaling();
        if (withCentering.booleanValue()) {
            shape = this.getCenterShape();
        } else if (withScaling.booleanValue()) {
            shape = this.getScaleShape();
        } else {
            return -1;
        }
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> scale;
        Boolean withCentering = this.getWithCentering();
        Boolean withScaling = this.getWithScaling();
        List<? extends Number> center = withCentering != false ? this.getCenter() : null;
        List<? extends Number> list = scale = withScaling != false ? this.getScale() : null;
        if (center == null && scale == null) {
            return features;
        }
        ClassDictUtil.checkSize(features, center, scale);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Double scaleValue;
            Feature feature = features.get(i);
            Double centerValue = withCentering != false ? (Number)center.get(i) : (Number)0.0;
            Number number = scaleValue = withScaling != false ? (Number)scale.get(i) : (Number)1.0;
            if (ValueUtil.isZero((Number)centerValue) && ValueUtil.isOne((Number)scaleValue)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isZero((Number)centerValue)) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)centerValue)});
            }
            if (!ValueUtil.isOne((Number)scaleValue)) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)scaleValue)});
            }
            DerivedField derivedField = encoder.createDerivedField(this.createName((Feature)continuousFeature), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        return result;
    }

    public Boolean getWithCentering() {
        return (Boolean)this.get("with_centering");
    }

    public Boolean getWithScaling() {
        return (Boolean)this.get("with_scaling");
    }

    public List<? extends Number> getCenter() {
        return ClassDictUtil.getArray(this, "center_");
    }

    public List<? extends Number> getScale() {
        return ClassDictUtil.getArray(this, "scale_");
    }

    private int[] getCenterShape() {
        return ClassDictUtil.getShape(this, "center_", 1);
    }

    private int[] getScaleShape() {
        return ClassDictUtil.getShape(this, "scale_", 1);
    }
}

