/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.EstimatorUtil;
import sklearn.ensemble.gradient_boosting.GradientBoostingUtil;
import sklearn.ensemble.gradient_boosting.HasPriorProbability;
import sklearn.ensemble.gradient_boosting.LossFunction;
import sklearn.tree.DecisionTreeRegressor;

public class GradientBoostingClassifier
extends Classifier {
    public GradientBoostingClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return ValueUtil.asInt((Number)((Number)this.get("n_features")));
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public MiningModel encodeModel(Schema schema) {
        LossFunction loss = this.getLoss();
        int numberOfClasses = loss.getK();
        HasPriorProbability init = this.getInit();
        Number learningRate = this.getLearningRate();
        List<DecisionTreeRegressor> estimators = this.getEstimators();
        Schema segmentSchema = new Schema((Label)new ContinuousLabel(null, DataType.DOUBLE), schema.getFeatures());
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (numberOfClasses == 1) {
            EstimatorUtil.checkSize(2, categoricalLabel);
            MiningModel miningModel = GradientBoostingUtil.encodeGradientBoosting(estimators, init.getPriorProbability(0), learningRate, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)("decisionFunction(" + categoricalLabel.getValue(1) + ")")), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{loss.createTransformation()}));
            return MiningModelUtil.createBinaryLogisticClassification((Model)miningModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)true, (Schema)schema);
        }
        if (numberOfClasses >= 3) {
            EstimatorUtil.checkSize(numberOfClasses, categoricalLabel);
            ArrayList<MiningModel> miningModels = new ArrayList<MiningModel>();
            int columns = categoricalLabel.size();
            int rows = estimators.size() / columns;
            for (int i = 0; i < columns; ++i) {
                MiningModel miningModel = GradientBoostingUtil.encodeGradientBoosting(CMatrixUtil.getColumn(estimators, (int)rows, (int)columns, (int)i), init.getPriorProbability(i), learningRate, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)("decisionFunction(" + categoricalLabel.getValue(i) + ")")), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{loss.createTransformation()}));
                miningModels.add(miningModel);
            }
            return MiningModelUtil.createClassification(miningModels, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SIMPLEMAX, (boolean)true, (Schema)schema);
        }
        throw new IllegalArgumentException();
    }

    public LossFunction getLoss() {
        Object loss = this.get("loss_");
        try {
            if (loss == null) {
                throw new NullPointerException();
            }
            return (LossFunction)((Object)loss);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("The loss function object (" + ClassDictUtil.formatClass(loss) + ") is not a LossFunction or is not a supported LossFunction subclass", re);
        }
    }

    public HasPriorProbability getInit() {
        Object init = this.get("init_");
        try {
            if (init == null) {
                throw new NullPointerException();
            }
            return (HasPriorProbability)init;
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("The estimator object (" + ClassDictUtil.formatClass(init) + ") is not a BaseEstimator or is not a supported BaseEstimator subclass", re);
        }
    }

    public Number getLearningRate() {
        return (Number)this.get("learning_rate");
    }

    public List<DecisionTreeRegressor> getEstimators() {
        return ClassDictUtil.getArray(this, "estimators_");
    }
}

