/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_extraction.text;

import java.util.List;
import numpy.DType;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.feature_extraction.text.CountVectorizer;
import sklearn.feature_extraction.text.TfidfTransformer;

public class TfidfVectorizer
extends CountVectorizer {
    public TfidfVectorizer(String module, String name) {
        super(module, name);
    }

    @Override
    public DType getDType() {
        TfidfTransformer transformer;
        DType dtype = super.getDType();
        if (dtype != null && (transformer = this.getTransformer()) != null) {
            DataType dataType = dtype.getDataType();
            switch (dataType) {
                case BOOLEAN: 
                case INTEGER: {
                    return null;
                }
                case FLOAT: 
                case DOUBLE: {
                    return dtype;
                }
            }
        }
        return dtype;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        TfidfTransformer transformer = this.getTransformer();
        String norm = transformer.getNorm();
        if (norm != null) {
            throw new IllegalArgumentException(norm);
        }
        return super.encodeFeatures(features, encoder);
    }

    @Override
    public DefineFunction encodeDefineFunction() {
        Boolean useIdf;
        TfidfTransformer transformer = this.getTransformer();
        DefineFunction defineFunction = super.encodeDefineFunction();
        Expression expression = defineFunction.getExpression();
        Boolean sublinearTf = transformer.getSublinearTf();
        if (sublinearTf.booleanValue()) {
            expression = PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{PMMLUtil.createApply((String)"log", (Expression[])new Expression[]{expression}), PMMLUtil.createConstant((Object)1.0)});
        }
        if ((useIdf = transformer.getUseIdf()).booleanValue()) {
            defineFunction.setName("tf-idf");
            ParameterField weight = new ParameterField(FieldName.create((String)"weight"));
            defineFunction.addParameterFields(new ParameterField[]{weight});
            expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, new FieldRef(weight.getName())});
        }
        defineFunction.setExpression(expression);
        return defineFunction;
    }

    @Override
    public Apply encodeApply(String function, Feature feature, int index, String term) {
        TfidfTransformer transformer = this.getTransformer();
        Apply apply = super.encodeApply(function, feature, index, term);
        Boolean useIdf = transformer.getUseIdf();
        if (useIdf.booleanValue()) {
            Number weight = transformer.getWeight(index);
            apply.addExpressions(new Expression[]{PMMLUtil.createConstant((Object)weight)});
        }
        return apply;
    }

    public TfidfTransformer getTransformer() {
        return (TfidfTransformer)((Object)this.get("_tfidf"));
    }
}

