/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Estimator;
import sklearn.EstimatorUtil;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public class Pipeline
extends Transformer {
    private boolean flexible = false;

    public Pipeline() {
        this("sklearn.pipeline", "Pipeline");
    }

    public Pipeline(String module, String name) {
        this(module, name, false);
    }

    protected Pipeline(String module, String name, boolean flexible) {
        super(module, name);
        this.setFlexible(flexible);
    }

    @Override
    public OpType getOpType() {
        List<Transformer> transformers = this.getTransformers();
        Iterator<Transformer> iterator = transformers.iterator();
        if (iterator.hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getOpType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public DataType getDataType() {
        List<Transformer> transformers = this.getTransformers();
        Iterator<Transformer> iterator = transformers.iterator();
        if (iterator.hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getDataType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Transformer> transformers = this.getTransformers();
        for (Transformer transformer : transformers) {
            HasNumberOfFeatures hasNumberOfFeatures;
            int numberOfFeatures;
            if (transformer instanceof HasNumberOfFeatures && (numberOfFeatures = (hasNumberOfFeatures = (HasNumberOfFeatures)((Object)transformer)).getNumberOfFeatures()) > -1) {
                ClassDictUtil.checkSize(numberOfFeatures, features);
            }
            encoder.updateFeatures(features, transformer);
            features = transformer.encodeFeatures(features, encoder);
        }
        return features;
    }

    public List<Transformer> getTransformers() {
        Estimator estimator;
        List<Object[]> steps = this.getSteps();
        boolean flexible = this.isFlexible();
        if (flexible && steps.size() > 0 && (estimator = this.getEstimator()) != null) {
            steps = steps.subList(0, steps.size() - 1);
        }
        return TransformerUtil.asTransformerList(TupleUtil.extractElementList(steps, 1));
    }

    public Estimator getEstimator() {
        List<Object[]> steps = this.getSteps();
        boolean flexible = this.isFlexible();
        if (flexible && steps.size() > 0) {
            Object lastStep = TupleUtil.extractElement(steps.get(steps.size() - 1), 1);
            try {
                return EstimatorUtil.asEstimator(lastStep);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<Object[]> getSteps() {
        return (List)this.get("steps");
    }

    private boolean isFlexible() {
        return this.flexible;
    }

    private void setFlexible(boolean flexible) {
        this.flexible = flexible;
    }
}

