/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.OpType;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.TypeUtil;
import sklearn2pmml.decoration.Domain;

public class CategoricalDomain
extends Domain {
    public CategoricalDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> data = this.getData();
        return TypeUtil.getDataType(data, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> data = this.getData();
        Boolean withStatistics = this.getWithStatistics();
        ClassDictUtil.checkSize(1, features);
        WildcardFeature wildcardFeature = (WildcardFeature)features.get(0);
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                return ValueUtil.formatValue((Object)object);
            }
        };
        List categories = Lists.transform(data, (Function)function);
        CategoricalFeature categoricalFeature = wildcardFeature.toCategoricalFeature(categories);
        if (withStatistics.booleanValue()) {
            Map<String, ?> counts = CategoricalDomain.extractMap(this.getCounts(), 0);
            Object[] discrStats = this.getDiscrStats();
            UnivariateStats univariateStats = new UnivariateStats().setField(categoricalFeature.getName()).setCounts(CategoricalDomain.createCounts(counts)).setDiscrStats(CategoricalDomain.createDiscrStats(discrStats));
            encoder.putUnivariateStats(univariateStats);
        }
        return super.encodeFeatures(Collections.singletonList(categoricalFeature), encoder);
    }

    public List<?> getData() {
        return ClassDictUtil.getArray(this, "data_");
    }

    public Object[] getDiscrStats() {
        return (Object[])this.get("discr_stats_");
    }

    public static DiscrStats createDiscrStats(Object[] objects) {
        List<?> values = CategoricalDomain.asArray(objects[0]);
        List counts = ValueUtil.asIntegers(CategoricalDomain.asArray(objects[1]));
        ClassDictUtil.checkSize(values, counts);
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object value) {
                return ValueUtil.formatValue((Object)value);
            }
        };
        Array valueArray = new Array(Array.Type.STRING, ValueUtil.formatArrayValue((List)Lists.transform(values, (Function)function)));
        Array countArray = new Array(Array.Type.INT, ValueUtil.formatArrayValue((List)Lists.transform((List)counts, (Function)function)));
        DiscrStats discrStats = new DiscrStats().addArrays(new Array[]{valueArray, countArray});
        return discrStats;
    }
}

