/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static int getNumberOfFeatures(HasBooster hasBooster) {
        Learner learner = BoosterUtil.getLearner(hasBooster);
        return learner.getNumFeatures();
    }

    public static MiningModel encodeBooster(HasBooster hasBooster, Schema schema) {
        Learner learner = BoosterUtil.getLearner(hasBooster);
        Schema xgbSchema = XGBoostUtil.toXGBoostSchema((Schema)schema);
        MiningModel miningModel = learner.encodeMiningModel(xgbSchema);
        return miningModel;
    }

    private static Learner getLearner(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getLearner();
    }
}

